/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.plugin;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cattleframework.cloud.discovery.enhancement.plugin.Plugin;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;

public class DefaultPluginRunner
implements PluginRunner {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPluginRunner.class);
    private static final String INVOKER_SOURCE = "invoker";
    private static final String INVOKER_OWNER = "cattle";
    private final ServiceInstance localServiceInstance;
    private final Multimap<PluginType, Plugin> pluginMap = ArrayListMultimap.create();

    public DefaultPluginRunner(List<Plugin> plugins, Registration registration) {
        if (CollectionUtils.isNotEmpty(plugins)) {
            plugins.forEach(plugin -> this.pluginMap.put((Object)plugin.getType(), plugin));
        }
        this.localServiceInstance = registration;
    }

    @Override
    public void run(PluginType pluginType, PluginContext context) {
        if (Arrays.stream(PluginType.Server.values()).anyMatch(value -> value == pluginType) && context.getRequest().getHttpHeaders().containsKey((Object)INVOKER_SOURCE) && INVOKER_OWNER.equalsIgnoreCase(context.getRequest().getHttpHeaders().getFirst(INVOKER_SOURCE))) {
            return;
        }
        for (Plugin plugin : this.pluginMap.get((Object)pluginType)) {
            try {
                logger.debug("\u6267\u884c\u63d2\u4ef6,\u7c7b\u578b:{},\u7c7b:{}", (Object)pluginType.toString(), (Object)plugin.getClass().getName());
                plugin.run(context);
            }
            catch (Throwable e) {
                plugin.handlerThrowable(context, e);
            }
        }
    }

    @Override
    public ServiceInstance getLocalServiceInstance() {
        return this.localServiceInstance;
    }
}

