/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.plugin;

import java.net.URI;
import java.util.Objects;
import org.cattleframework.cloud.discovery.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.ResponseContext;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class PluginContext {
    private RequestContext requestContext;
    private ResponseContext responseContext;
    private Throwable throwable;
    private ServiceInstance localServiceInstance;
    private long delay;
    private ServiceInstance targetServiceInstance;

    public RequestContext getRequest() {
        return this.requestContext;
    }

    public void setRequest(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public ResponseContext getResponse() {
        return this.responseContext;
    }

    public void setResponse(ResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public ServiceInstance getLocalServiceInstance() {
        return this.localServiceInstance;
    }

    public void setLocalServiceInstance(ServiceInstance localServiceInstance) {
        this.localServiceInstance = localServiceInstance;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public ServiceInstance getTargetServiceInstance() {
        return this.targetServiceInstance;
    }

    public void setTargetServiceInstance(ServiceInstance targetServiceInstance, URI url) {
        if (Objects.nonNull(targetServiceInstance)) {
            this.targetServiceInstance = targetServiceInstance;
        } else if (Objects.nonNull(url)) {
            DefaultServiceInstance defaultServiceInstance = new DefaultServiceInstance();
            defaultServiceInstance.setUri(url);
            if (defaultServiceInstance.isSecure()) {
                defaultServiceInstance.setPort(443);
            } else {
                defaultServiceInstance.setPort(80);
            }
            this.targetServiceInstance = defaultServiceInstance;
        } else {
            this.targetServiceInstance = new DefaultServiceInstance();
        }
    }
}

