/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.plugin;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class RequestContext {
    private final URI url;
    private final HttpMethod httpMethod;
    private final HttpHeaders httpHeaders;
    private final Map<String, String> parameters;

    public RequestContext(URI url, HttpMethod httpMethod, HttpHeaders httpHeaders, Map<String, String> parameters) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.httpHeaders = httpHeaders;
        this.parameters = parameters;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getParameter(String name) {
        return this.parameters != null ? this.parameters.get(name) : null;
    }

    public static ContextRequestBuilder builder() {
        return new ContextRequestBuilder();
    }

    public static final class ContextRequestBuilder {
        private HttpMethod httpMethod;
        private HttpHeaders httpHeaders;
        private URI url;
        private final Map<String, String> parameters = new HashMap<String, String>();

        private ContextRequestBuilder() {
        }

        public ContextRequestBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public ContextRequestBuilder httpHeaders(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public ContextRequestBuilder url(URI url) {
            String query = url.getQuery();
            if (StringUtils.isBlank((CharSequence)query)) {
                this.url = url;
            } else {
                this.url = URI.create(String.format("%s://%s:%d%s", url.getScheme(), url.getHost(), url.getPort(), url.getPath()));
                String[] parameterArray = StringUtils.split((String)query, (String)"&");
                Arrays.stream(parameterArray).forEach(parameter -> {
                    int pos = parameter.indexOf("=");
                    if (pos >= 0) {
                        this.parameters.put(parameter.substring(0, pos), parameter.substring(pos + 1));
                    } else {
                        this.parameters.put((String)parameter, "");
                    }
                });
            }
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.url, this.httpMethod, this.httpHeaders, this.parameters);
        }
    }
}

