/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.scg;

import java.net.URI;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginType;
import org.cattleframework.cloud.discovery.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.ResponseContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayFilter
implements GlobalFilter,
Ordered {
    private final PluginRunner pluginRunner;

    public GatewayFilter(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public int getOrder() {
        return 10151;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        PluginContext pluginContext = new PluginContext();
        URI uri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        RequestContext requestContext = RequestContext.builder().httpHeaders(exchange.getRequest().getHeaders()).httpMethod(exchange.getRequest().getMethod()).url(uri).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        Response serviceInstanceResponse = (Response)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR);
        if (serviceInstanceResponse != null && serviceInstanceResponse.hasServer()) {
            ServiceInstance instance = (ServiceInstance)serviceInstanceResponse.getServer();
            pluginContext.setTargetServiceInstance(instance, exchange.getRequest().getURI());
        } else {
            pluginContext.setTargetServiceInstance(null, uri);
        }
        this.pluginRunner.run(PluginType.Client.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        return chain.filter(exchange).doOnSuccess(v -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            ResponseContext responseContext = ResponseContext.builder().httpStatus(exchange.getResponse().getStatusCode() != null ? Integer.valueOf(exchange.getResponse().getStatusCode().value()) : null).httpHeaders(exchange.getResponse().getHeaders()).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Client.POST, pluginContext);
        }).doOnError(e -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable((Throwable)e);
            this.pluginRunner.run(PluginType.Client.EXCEPTION, pluginContext);
        }).doFinally(v -> this.pluginRunner.run(PluginType.Client.FINALLY, pluginContext));
    }
}

