/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.loadbalancer;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cattleframework.cloud.discovery.event.LoadBalancerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

abstract class BaseCloudLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(BaseCloudLoadBalancer.class);
    protected final String serviceId;
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final List<LoadBalancerEvent> loadBalancerEvents;

    abstract Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> var1);

    public BaseCloudLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, List<LoadBalancerEvent> loadBalancerEvents) {
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.loadBalancerEvents = loadBalancerEvents;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> {
            if (serviceInstances.isEmpty()) {
                logger.warn("No servers available for service: " + this.serviceId);
                return new EmptyResponse();
            }
            this.filterInstances(request, (List<ServiceInstance>)serviceInstances);
            return this.processInstanceResponse(supplier, (List<ServiceInstance>)serviceInstances);
        });
    }

    private void filterInstances(Request request, List<ServiceInstance> serviceInstances) {
        RequestData requestData;
        RequestDataContext requestDataContext = request.getContext() != null && request.getContext() instanceof RequestDataContext ? (RequestDataContext)request.getContext() : null;
        RequestData requestData2 = requestData = requestDataContext != null ? requestDataContext.getClientRequest() : null;
        if (CollectionUtils.isNotEmpty(this.loadBalancerEvents)) {
            this.loadBalancerEvents.forEach(loadBalancerEvent -> {
                logger.debug("\u6267\u884c\u8d1f\u8f7d\u5747\u8861\u5668\u4e8b\u4ef6\u7c7b:{}", (Object)loadBalancerEvent.getClass().getName());
                loadBalancerEvent.onFilter(requestData, this.serviceId, serviceInstances);
            });
        }
    }

    private Response<ServiceInstance> processInstanceResponse(ServiceInstanceListSupplier supplier, List<ServiceInstance> serviceInstances) {
        Response<ServiceInstance> serviceInstanceResponse = this.getInstanceResponse(serviceInstances);
        if (supplier instanceof SelectedInstanceCallback && serviceInstanceResponse.hasServer()) {
            ((SelectedInstanceCallback)supplier).selectedServiceInstance((ServiceInstance)serviceInstanceResponse.getServer());
        }
        return serviceInstanceResponse;
    }
}

