/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.loadbalancer;

import java.util.List;
import org.cattleframework.cloud.discovery.LoadBalancerProperties;
import org.cattleframework.cloud.discovery.event.LoadBalancerEvent;
import org.cattleframework.cloud.discovery.loadbalancer.RandomCloudLoadBalancer;
import org.cattleframework.cloud.discovery.loadbalancer.RoundRobinCloudLoadBalancer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplierBuilder;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class CloudLoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 183827460;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cattle.cloud.loadbalancer.strategy"}, havingValue="roundRobin", matchIfMissing=true)
    public ReactorLoadBalancer<ServiceInstance> roundRobinLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, @Nullable List<LoadBalancerEvent> loadBalancerEvents) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RoundRobinCloudLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name, loadBalancerEvents);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cattle.cloud.loadbalancer.strategy"}, havingValue="random")
    public ReactorLoadBalancer<ServiceInstance> randomLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, @Nullable List<LoadBalancerEvent> loadBalancerEvents) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RandomCloudLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name, loadBalancerEvents);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=183827461)
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier serviceInstanceListSupplier(ConfigurableApplicationContext context, LoadBalancerProperties loadBalancerProperties) {
            ServiceInstanceListSupplierBuilder serviceInstanceListSupplierBuilder = ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient();
            if (loadBalancerProperties.isCache()) {
                serviceInstanceListSupplierBuilder = serviceInstanceListSupplierBuilder.withCaching();
            }
            return serviceInstanceListSupplierBuilder.build(context);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=183827460)
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier serviceInstanceListSupplier(ConfigurableApplicationContext context, LoadBalancerProperties loadBalancerProperties) {
            ServiceInstanceListSupplierBuilder serviceInstanceListSupplierBuilder = ServiceInstanceListSupplier.builder().withDiscoveryClient();
            if (loadBalancerProperties.isCache()) {
                serviceInstanceListSupplierBuilder = serviceInstanceListSupplierBuilder.withCaching();
            }
            return serviceInstanceListSupplierBuilder.build(context);
        }
    }
}

