/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.cattleframework.cloud.discovery.event.LoadBalancerEvent;
import org.cattleframework.cloud.discovery.loadbalancer.BaseCloudLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;

public class RandomCloudLoadBalancer
extends BaseCloudLoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(RandomCloudLoadBalancer.class);

    public RandomCloudLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, List<LoadBalancerEvent> loadBalancerEvents) {
        super(serviceInstanceListSupplierProvider, serviceId, loadBalancerEvents);
    }

    @Override
    Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (logger.isWarnEnabled()) {
                logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        int index = ThreadLocalRandom.current().nextInt(instances.size());
        ServiceInstance instance = instances.get(index);
        return new DefaultResponse(instance);
    }
}

