/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.loadbalancer;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.cattleframework.cloud.discovery.event.LoadBalancerEvent;
import org.cattleframework.cloud.discovery.loadbalancer.BaseCloudLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;

public class RoundRobinCloudLoadBalancer
extends BaseCloudLoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinCloudLoadBalancer.class);
    private final AtomicInteger position;

    public RoundRobinCloudLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, List<LoadBalancerEvent> loadBalancerEvents) {
        this(serviceInstanceListSupplierProvider, serviceId, new Random().nextInt(1000), loadBalancerEvents);
    }

    public RoundRobinCloudLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, int seedPosition, List<LoadBalancerEvent> loadBalancerEvents) {
        super(serviceInstanceListSupplierProvider, serviceId, loadBalancerEvents);
        this.position = new AtomicInteger(seedPosition);
    }

    @Override
    Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            if (logger.isWarnEnabled()) {
                logger.warn("No servers available for service: " + this.serviceId);
            }
            return new EmptyResponse();
        }
        if (instances.size() == 1) {
            return new DefaultResponse(instances.get(0));
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        ServiceInstance instance = instances.get(pos % instances.size());
        return new DefaultResponse(instance);
    }
}

