/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.processor;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.aop.SpringContext;
import org.cattleframework.cloud.discovery.processor.DiscoveryMetadataProcessor;
import org.cattleframework.cloud.discovery.processor.DiscoveryPropertiesProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;

public abstract class BaseDiscoveryPropertiesProcessor
implements DiscoveryPropertiesProcessor {
    protected void putMetadata(ConfigurableListableBeanFactory beanFactory, Environment environment, Map<String, String> metadata) {
        String applicationName = SpringContext.get().getApplicationName();
        metadata.put("application-name", StringUtils.isNotBlank((CharSequence)applicationName) ? applicationName : "unknown");
        String contextPath = SpringContext.get().getContextPath();
        metadata.put("context-path", StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath);
        List<DiscoveryMetadataProcessor> discoveryMetadataProcessors = beanFactory.getBeansOfType(DiscoveryMetadataProcessor.class).values().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(discoveryMetadataProcessors)) {
            AnnotationAwareOrderComparator.sort(discoveryMetadataProcessors);
            discoveryMetadataProcessors.forEach(discoveryMetadataProcessor -> discoveryMetadataProcessor.putMetadata(beanFactory, environment, metadata));
        }
    }
}

