/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.reflect;

import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cattleframework.cloud.discovery.event.DiscoveryClientEvent;
import org.cattleframework.utils.reflect.ReflectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DiscoveryClientInvocationHandler
extends AbstractInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClientInvocationHandler.class);
    private static final String METHOD_NAME_GET_INSTANCES = "getInstances";
    private final DiscoveryClient target;
    private final List<DiscoveryClientEvent> discoveryClientEvents;

    public DiscoveryClientInvocationHandler(DiscoveryClient target, List<DiscoveryClientEvent> discoveryClientEvents) {
        this.target = target;
        this.discoveryClientEvents = discoveryClientEvents;
    }

    protected Object handleInvocation(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Object result = ReflectUtils.invokeObjectMethod((Method)method, (Object)this.target, (Object[])args);
        String methodName = method.getName();
        if (METHOD_NAME_GET_INSTANCES.equals(methodName) && CollectionUtils.isNotEmpty(this.discoveryClientEvents)) {
            String serviceId = (String)args[0];
            List serviceInstances = (List)result;
            this.discoveryClientEvents.forEach(discoveryClientEvent -> {
                logger.debug("\u6267\u884c\u670d\u52a1\u53d1\u73b0\u5ba2\u6237\u7aef\u4e8b\u4ef6\u7c7b:{}", (Object)discoveryClientEvent.getClass().getName());
                discoveryClientEvent.onGetInstances(serviceId, serviceInstances);
            });
            return serviceInstances;
        }
        return result;
    }
}

