/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.reflect;

import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cattleframework.cloud.discovery.event.DiscoveryClientEvent;
import org.cattleframework.cloud.discovery.reflect.DiscoveryClientInvocationHandler;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public interface DiscoveryClientProxy
extends DiscoveryClient {
    public DiscoveryClient getTargetDiscoveryClient();

    public static DiscoveryClient getDiscoveryClientProxy(ConfigurableListableBeanFactory beanFactory, DiscoveryClient target) {
        List<DiscoveryClientEvent> discoveryClientEvents = beanFactory.getBeansOfType(DiscoveryClientEvent.class).values().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(discoveryClientEvents)) {
            AnnotationAwareOrderComparator.sort(discoveryClientEvents);
        }
        return (DiscoveryClient)Reflection.newProxy(DiscoveryClientProxy.class, (InvocationHandler)((Object)new DiscoveryClientInvocationHandler(target, discoveryClientEvents)));
    }
}

