/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.reflect;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.cattleframework.cloud.discovery.event.ServiceRegistryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;

@Aspect
public class ServiceRegistryAspect {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistryAspect.class);
    private final List<ServiceRegistryEvent> serviceRegistryEvents;

    public ServiceRegistryAspect(List<ServiceRegistryEvent> serviceRegistryEvents) {
        this.serviceRegistryEvents = serviceRegistryEvents;
    }

    @Pointcut(value="execution(public * org.springframework.cloud.client.serviceregistry.ServiceRegistry.register(..))")
    public void registerAspect() {
    }

    @Around(value="registerAspect()")
    public void register(ProceedingJoinPoint joinPoint) throws Throwable {
        if (CollectionUtils.isNotEmpty(this.serviceRegistryEvents)) {
            Registration registration = (Registration)joinPoint.getArgs()[0];
            this.serviceRegistryEvents.forEach(serviceRegistryEvent -> {
                logger.debug("\u6267\u884c\u670d\u52a1\u6ce8\u518c\u4e8b\u4ef6\u7c7b:{}", (Object)serviceRegistryEvent.getClass().getName());
                serviceRegistryEvent.onRegister(registration);
            });
        }
        joinPoint.proceed();
    }
}

