/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.cache;

/**
 * 缓存
 * 
 * @author orange
 *
 */
public interface Cache {

    /**
     * 获取值
     * 
     * @param key 键值
     * @return 值
     */
    Object get(String key);

    /**
     * 赋值
     * 
     * @param key   键值
     * @param value 值
     */
    void put(String key, Object value);

    /**
     * 移除值
     * 
     * @param key 键值
     */
    void remove(String key);

    /**
     * 清理
     */
    void clear();
}