package com.zxl.ai.client;


import com.yupi.yucongming.dev.client.YuCongMingClient;
import com.yupi.yucongming.dev.common.BaseResponse;
import com.yupi.yucongming.dev.model.DevChatRequest;
import com.yupi.yucongming.dev.model.DevChatResponse;
import com.zxl.ai.utils.AiUtil;
import lombok.Data;

import javax.annotation.Resource;

@Data
public class AIClient {
    private String ak;
    private String sk;

    public AIClient(String ak, String sk) {
        this.ak = ak;
        this.sk = sk;
    }

    @Resource
    private YuCongMingClient client;

    public String genAIResponse(String message, String ak, String sk) {
        // 验签 TODO
        if (!"zxl".equals(ak)) {
            throw new RuntimeException("ak无效");
        }

        if (!"zxl".equals(sk)) {
            throw new RuntimeException("sk无效");
        }

        return AiUtil.genResponse(message, client);
    }

}
