/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.kafka;

import io.goodforgod.testcontainers.extensions.kafka.EventImpl;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public interface Event {
    public Key key();

    @NotNull
    public Value value();

    @NotNull
    public List<Header> headers();

    @NotNull
    public static Builder builder() {
        return new EventImpl.EventBuilder();
    }

    @NotNull
    public static Event ofValue(byte[] valueAsBytes) {
        return new EventImpl(null, new EventImpl.ValueImpl(valueAsBytes), Collections.emptyList());
    }

    @NotNull
    public static Event ofValue(@NotNull String valueAsString) {
        return Event.ofValue(valueAsString.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Event ofValue(@NotNull JSONObject valueAsJson) {
        return Event.ofValue(valueAsJson.toString().getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Event ofValue(@NotNull JSONArray valueAsJsonArray) {
        return Event.ofValue(valueAsJsonArray.toString().getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Event ofValueAndRandomKey(byte[] valueAsBytes) {
        return new EventImpl(new EventImpl.KeyImpl(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)), new EventImpl.ValueImpl(valueAsBytes), Collections.emptyList());
    }

    @NotNull
    public static Event ofValueAndRandomKey(@NotNull String valueAsString) {
        return Event.ofValueAndRandomKey(valueAsString.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Event ofValueAndRandomKey(@NotNull JSONObject valueAsJson) {
        return Event.ofValueAndRandomKey(valueAsJson.toString().getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Event ofValueAndRandomKey(@NotNull JSONArray valueAsJsonArray) {
        return Event.ofValueAndRandomKey(valueAsJsonArray.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static interface Key {
        public byte[] asBytes();

        @NotNull
        public String asString();
    }

    public static interface Value {
        public byte[] asBytes();

        @NotNull
        public String asString();

        @NotNull
        public JSONObject asJson();

        @NotNull
        public JSONArray asJsonArray();
    }

    public static interface Builder {
        @NotNull
        public Builder withKey(@NotNull String var1);

        @NotNull
        public Builder withKey(byte[] var1);

        @NotNull
        public Builder withValue(byte[] var1);

        @NotNull
        public Builder withValue(@NotNull String var1);

        @NotNull
        public Builder withValue(@NotNull JSONObject var1);

        @NotNull
        public Builder withValue(@NotNull JSONArray var1);

        @NotNull
        public Builder withHeader(@NotNull String var1, byte[] var2);

        @NotNull
        public Builder withHeader(@NotNull String var1, @NotNull String var2);

        @NotNull
        public Event build();
    }

    public static interface Header {
        @NotNull
        public String key();

        @NotNull
        public Value value();
    }
}

