/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.kafka;

import io.goodforgod.testcontainers.extensions.kafka.Event;
import io.goodforgod.testcontainers.extensions.kafka.KafkaConnectionClosableImpl;
import io.goodforgod.testcontainers.extensions.kafka.ReceivedEvent;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.Admin;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.KafkaContainer;

public interface KafkaConnection
extends AutoCloseable {
    @NotNull
    public Params params();

    @NotNull
    public Optional<Params> paramsInNetwork();

    @NotNull
    public Admin admin();

    public void createTopics(@NotNull Set<String> var1);

    public void dropTopics(@NotNull Set<String> var1);

    @NotNull
    default public KafkaConnection withProperties(@NotNull Map<String, String> properties) {
        Properties props = new Properties();
        props.putAll(properties);
        return this.withProperties(props);
    }

    @NotNull
    public KafkaConnection withProperties(@NotNull Properties var1);

    public void send(@NotNull String var1, Event ... var2);

    public void send(@NotNull String var1, @NotNull List<Event> var2);

    @NotNull
    public Consumer subscribe(String ... var1);

    @NotNull
    public Consumer subscribe(@NotNull Set<String> var1);

    @NotNull
    public static KafkaConnection forContainer(@NotNull KafkaContainer container) {
        if (!container.isRunning()) {
            throw new IllegalStateException(container.getClass().getSimpleName() + " container is not running");
        }
        Properties properties = new Properties();
        properties.put("bootstrap.servers", container.getBootstrapServers());
        Properties networkProperties = new Properties();
        networkProperties.put("bootstrap.servers", String.format("%s:%s", container.getNetworkAliases().get(0), "9092"));
        return new KafkaConnectionClosableImpl(properties, networkProperties);
    }

    @NotNull
    public static KafkaConnection forBootstrapServers(@NotNull String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        return new KafkaConnectionClosableImpl(properties, null);
    }

    @NotNull
    public static KafkaConnection forProperties(@NotNull Properties properties) {
        return new KafkaConnectionClosableImpl(properties, null);
    }

    @Override
    public void close();

    public static interface Consumer
    extends AutoCloseable {
        public void reset();

        @NotNull
        public List<ReceivedEvent> receivedPreviously();

        @NotNull
        public Optional<ReceivedEvent> getReceived(@NotNull Duration var1);

        @NotNull
        default public Optional<ReceivedEvent> getReceived() {
            return this.getReceived(Duration.ofSeconds(15L));
        }

        @NotNull
        public ReceivedEvent getReceivedAtLeastOne(@NotNull Duration var1);

        @NotNull
        default public ReceivedEvent getReceivedAtLeastOne() {
            return this.getReceivedAtLeastOne(Duration.ofSeconds(15L));
        }

        @NotNull
        public List<ReceivedEvent> getReceivedAtLeast(int var1, @NotNull Duration var2);

        @NotNull
        default public List<ReceivedEvent> getReceivedAtLeast(int expectedEvents) {
            return this.getReceivedAtLeast(expectedEvents, Duration.ofSeconds(15L));
        }

        public void assertReceivedNone(@NotNull Duration var1);

        @NotNull
        public ReceivedEvent assertReceivedAtLeastOne(@NotNull Duration var1);

        @NotNull
        default public ReceivedEvent assertReceivedAtLeastOne() {
            return this.assertReceivedAtLeastOne(Duration.ofSeconds(15L));
        }

        @NotNull
        public List<ReceivedEvent> assertReceivedAtLeast(int var1, @NotNull Duration var2);

        @NotNull
        default public List<ReceivedEvent> assertReceivedAtLeast(int expectedAtLeast) {
            return this.assertReceivedAtLeast(expectedAtLeast, Duration.ofSeconds(15L));
        }

        @NotNull
        public List<ReceivedEvent> assertReceivedEqualsInTime(int var1, @NotNull Duration var2);

        public boolean checkReceivedNone(@NotNull Duration var1);

        default public boolean checkReceivedAtLeast(int expectedAtLeast) {
            return this.checkReceivedAtLeast(expectedAtLeast, Duration.ofSeconds(15L));
        }

        public boolean checkReceivedAtLeast(int var1, @NotNull Duration var2);

        public boolean checkReceivedEqualsInTime(int var1, @NotNull Duration var2);

        @Override
        public void close();
    }

    public static interface Params {
        @NotNull
        public String bootstrapServers();

        @NotNull
        public Properties properties();
    }
}

