/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.kafka;

import io.goodforgod.testcontainers.extensions.kafka.Event;
import io.goodforgod.testcontainers.extensions.kafka.EventImpl;
import io.goodforgod.testcontainers.extensions.kafka.ReceivedEvent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class ReceivedEventImpl
implements ReceivedEvent {
    private final Event.Key key;
    private final Event.Value value;
    private final List<Event.Header> headers;
    private final String topic;
    private final int partition;
    private final long offset;
    private final long timestamp;

    public ReceivedEventImpl(ConsumerRecord<byte[], byte[]> record) {
        this(record.key() == null ? null : new EventImpl.KeyImpl((byte[])record.key()), new EventImpl.ValueImpl((byte[])record.value()), ReceivedEventImpl.getHeaders(record), record.topic(), record.partition(), record.offset(), record.timestamp());
    }

    private static List<Event.Header> getHeaders(ConsumerRecord<byte[], byte[]> record) {
        ArrayList<EventImpl.HeaderImpl> headers = new ArrayList<EventImpl.HeaderImpl>();
        for (Header header : record.headers()) {
            headers.add(new EventImpl.HeaderImpl(header.key(), new EventImpl.ValueImpl(header.value())));
        }
        return List.copyOf(headers);
    }

    ReceivedEventImpl(Event.Key key, Event.Value value, List<Event.Header> headers, String topic, int partition, long offset, long timestamp) {
        this.key = key;
        this.value = value;
        this.headers = headers;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    @Override
    public Event.Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public Event.Value value() {
        return this.value;
    }

    @Override
    @NotNull
    public List<Event.Header> headers() {
        return this.headers;
    }

    @Override
    @NotNull
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public OffsetDateTime datetime() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.of("Z"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceivedEventImpl event = (ReceivedEventImpl)o;
        return this.partition == event.partition && this.offset == event.offset && this.timestamp == event.timestamp && Objects.equals(this.key, event.key) && Objects.equals(this.value, event.value) && Objects.equals(this.headers, event.headers) && Objects.equals(this.topic, event.topic);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.headers, this.topic, this.partition, this.offset, this.timestamp);
    }

    public String toString() {
        if (this.key == null && this.headers.isEmpty()) {
            return "[topic=" + this.topic + ", offset=" + this.offset + ", timestamp=" + this.datetime() + ", value=" + this.value + ", partition=" + this.partition + "]";
        }
        if (this.key == null) {
            return "[topic=" + this.topic + ", offset=" + this.offset + ", timestamp=" + this.datetime() + ", value=" + this.value + ", headers=" + this.headers + ", partition=" + this.partition + "]";
        }
        if (this.headers.isEmpty()) {
            return "[topic=" + this.topic + ", offset=" + this.offset + ", timestamp=" + this.datetime() + ", key=" + this.key + ", value=" + this.value + ", partition=" + this.partition + "]";
        }
        return "[topic=" + this.topic + ", offset=" + this.offset + ", timestamp=" + this.datetime() + ", key=" + this.key + ", value=" + this.value + ", headers=" + this.headers + ", partition=" + this.partition + "]";
    }
}

