/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.jdbc.AbstractTestcontainersJdbcExtension;
import io.goodforgod.testcontainers.extensions.jdbc.ContainerMysql;
import io.goodforgod.testcontainers.extensions.jdbc.ContainerMysqlConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionImpl;
import io.goodforgod.testcontainers.extensions.jdbc.MysqlMetadata;
import io.goodforgod.testcontainers.extensions.jdbc.TestcontainersMysql;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

final class TestcontainersMysqlExtension
extends AbstractTestcontainersJdbcExtension<MySQLContainer<?>, MysqlMetadata> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersMysqlExtension.class});
    private static final String PROTOCOL = "mysql";
    private static final String DATABASE_NAME = "test";
    private static final String EXTERNAL_TEST_MYSQL_JDBC_URL = "EXTERNAL_TEST_MYSQL_JDBC_URL";
    private static final String EXTERNAL_TEST_MYSQL_USERNAME = "EXTERNAL_TEST_MYSQL_USERNAME";
    private static final String EXTERNAL_TEST_MYSQL_PASSWORD = "EXTERNAL_TEST_MYSQL_PASSWORD";
    private static final String EXTERNAL_TEST_MYSQL_HOST = "EXTERNAL_TEST_MYSQL_HOST";
    private static final String EXTERNAL_TEST_MYSQL_PORT = "EXTERNAL_TEST_MYSQL_PORT";
    private static final String EXTERNAL_TEST_MYSQL_DATABASE = "EXTERNAL_TEST_MYSQL_DATABASE";

    TestcontainersMysqlExtension() {
    }

    protected Class<MySQLContainer<?>> getContainerType() {
        return MySQLContainer.class;
    }

    protected Class<? extends Annotation> getContainerAnnotation() {
        return ContainerMysql.class;
    }

    protected Class<? extends Annotation> getConnectionAnnotation() {
        return ContainerMysqlConnection.class;
    }

    protected MySQLContainer<?> getContainerDefault(MysqlMetadata metadata) {
        DockerImageName dockerImage = DockerImageName.parse((String)metadata.image()).asCompatibleSubstituteFor(DockerImageName.parse((String)PROTOCOL));
        MySQLContainer container = (MySQLContainer)((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(dockerImage).withDatabaseName(DATABASE_NAME).withUsername(PROTOCOL).withPassword(PROTOCOL).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(MySQLContainer.class)).withMdc("image", metadata.image()).withMdc("alias", metadata.networkAlias()))).withNetworkAliases(new String[]{metadata.networkAlias()})).waitingFor((WaitStrategy)Wait.forListeningPort())).withStartupTimeout(Duration.ofMinutes(5L));
        if (metadata.networkShared()) {
            container.withNetwork(Network.SHARED);
        }
        return container;
    }

    protected ExtensionContext.Namespace getNamespace() {
        return NAMESPACE;
    }

    @NotNull
    protected Optional<MysqlMetadata> findMetadata(@NotNull ExtensionContext context) {
        return this.findAnnotation(TestcontainersMysql.class, context).map(a -> new MysqlMetadata(a.network().shared(), a.network().alias(), a.image(), a.mode(), a.migration()));
    }

    @NotNull
    protected JdbcConnection getConnectionForContainer(MysqlMetadata metadata, @NotNull MySQLContainer<?> container) {
        String alias = Optional.ofNullable(metadata.networkAlias()).or(() -> container.getNetworkAliases().isEmpty() ? Optional.empty() : Optional.of((String)container.getNetworkAliases().get(container.getNetworkAliases().size() - 1))).orElse(null);
        return JdbcConnectionImpl.forJDBC((String)container.getJdbcUrl(), (String)container.getHost(), (int)container.getMappedPort(MySQLContainer.MYSQL_PORT.intValue()), (String)alias, (Integer)MySQLContainer.MYSQL_PORT, (String)container.getDatabaseName(), (String)container.getUsername(), (String)container.getPassword());
    }

    @NotNull
    protected Optional<JdbcConnection> getConnectionExternal() {
        String url = System.getenv(EXTERNAL_TEST_MYSQL_JDBC_URL);
        String host = System.getenv(EXTERNAL_TEST_MYSQL_HOST);
        String port = System.getenv(EXTERNAL_TEST_MYSQL_PORT);
        String user = System.getenv(EXTERNAL_TEST_MYSQL_USERNAME);
        String password = System.getenv(EXTERNAL_TEST_MYSQL_PASSWORD);
        String db = Optional.ofNullable(System.getenv(EXTERNAL_TEST_MYSQL_DATABASE)).orElse(DATABASE_NAME);
        if (url != null) {
            if (host != null && port != null) {
                return Optional.of(JdbcConnectionImpl.forJDBC((String)url, (String)host, (int)Integer.parseInt(port), null, null, (String)db, (String)user, (String)password));
            }
            return Optional.of(JdbcConnectionImpl.forExternal((String)url, (String)user, (String)password));
        }
        if (host != null && port != null) {
            return Optional.of(JdbcConnectionImpl.forProtocol((String)PROTOCOL, (String)host, (int)Integer.parseInt(port), (String)db, (String)user, (String)password));
        }
        return Optional.empty();
    }
}

