/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.am.factor.api;

import io.gravitee.am.gateway.handler.context.EvaluableExecutionContext;
import io.gravitee.am.model.User;
import io.gravitee.am.model.oidc.Client;
import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateEngine;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class FactorContext {
    public static final String KEY_ENROLLED_FACTOR = "enrolledFactor";
    public static final String KEY_RECOVERY_FACTOR = "recoveryFactor";
    public static final String KEY_CODE = "code";
    public static final String KEY_CLIENT = "client";
    public static final String KEY_USER = "user";
    public static final String KEY_REQUEST = "request";
    private final ApplicationContext appContext;
    private final Map<String, Object> data;
    private TemplateEngine templateEngine;

    public FactorContext(ApplicationContext appContext, Map<String, Object> data) {
        this.appContext = appContext;
        this.data = data;
    }

    public <T> T getComponent(Class<T> componentClass) {
        return (T)this.appContext.getBean(componentClass);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public <T> T getData(String key, Class<T> type) {
        if (this.data != null) {
            return type.cast(this.getData().get(key));
        }
        return null;
    }

    public <V> void registerData(String key, V value) {
        this.data.put(key, value);
    }

    public Client getClient() {
        return this.getData(KEY_CLIENT, Client.class);
    }

    public User getUser() {
        return this.getData(KEY_USER, User.class);
    }

    public Map<String, Object> getTemplateValues() {
        return this.getData();
    }

    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            this.templateEngine = TemplateEngine.templateEngine();
            TemplateContext templateContext = this.templateEngine.getTemplateContext();
            if (this.data.get(KEY_REQUEST) != null) {
                templateContext.setVariable(KEY_REQUEST, this.data.get(KEY_REQUEST));
            }
            templateContext.setVariable("context", (Object)new EvaluableExecutionContext(this.getTemplateValues()));
        }
        return this.templateEngine;
    }
}

