/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.am.factor.api;

import io.gravitee.am.common.exception.mfa.InvalidCodeException;
import io.gravitee.am.factor.api.FactorProvider;
import io.gravitee.am.factor.utils.HOTP;
import io.gravitee.am.factor.utils.SharedSecret;
import io.gravitee.am.model.factor.EnrolledFactor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OTPFactorProvider
implements FactorProvider {
    private Logger logger = LoggerFactory.getLogger(OTPFactorProvider.class);

    @Override
    public boolean useVariableFactorSecurity() {
        return true;
    }

    @Override
    public Single<EnrolledFactor> changeVariableFactorSecurity(EnrolledFactor enrolledFactor) {
        if (enrolledFactor.getSecurity() == null || enrolledFactor.getSecurity().getData("MOVING_FACTOR", Number.class) == null) {
            return Single.just((Object)enrolledFactor);
        }
        return Single.fromCallable(() -> {
            this.incrementMovingFactor(enrolledFactor);
            enrolledFactor.getSecurity().removeData("EXPIRATION_EPOCH");
            return enrolledFactor;
        });
    }

    protected Completable verifyOTP(EnrolledFactor enrolledFactor, int returnDigits, String code) {
        return Completable.create(emitter -> {
            try {
                String otpCode = this.generateOTP(enrolledFactor, returnDigits);
                if (!code.equals(otpCode)) {
                    emitter.onError((Throwable)new InvalidCodeException("Invalid 2FA Code"));
                }
                if (Instant.now().isAfter(Instant.ofEpochMilli((Long)enrolledFactor.getSecurity().getData("EXPIRATION_EPOCH", Long.class)))) {
                    emitter.onError((Throwable)new InvalidCodeException("Invalid 2FA Code"));
                }
                emitter.onComplete();
            }
            catch (Exception ex) {
                this.logger.error("An error occurs while validating 2FA code", (Throwable)ex);
                emitter.onError((Throwable)new InvalidCodeException("Invalid 2FA Code"));
            }
        });
    }

    protected String generateOTP(EnrolledFactor enrolledFactor, int returnDigits) throws NoSuchAlgorithmException, InvalidKeyException {
        return HOTP.generateOTP(SharedSecret.base32Str2Bytes(enrolledFactor.getSecurity().getValue()), ((Number)enrolledFactor.getSecurity().getData("MOVING_FACTOR", Number.class)).longValue(), returnDigits, false, 0);
    }

    protected void incrementMovingFactor(EnrolledFactor factor) {
        long counter = ((Number)factor.getSecurity().getData("MOVING_FACTOR", Number.class)).longValue();
        factor.getSecurity().putData("MOVING_FACTOR", (Object)(counter + 1L));
    }
}

