/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.am.factor.call.provider;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import io.gravitee.am.factor.api.Enrollment;
import io.gravitee.am.factor.api.FactorContext;
import io.gravitee.am.factor.api.FactorProvider;
import io.gravitee.am.factor.call.CallFactorConfiguration;
import io.gravitee.am.gateway.handler.manager.resource.ResourceManager;
import io.gravitee.am.model.factor.EnrolledFactor;
import io.gravitee.am.model.factor.EnrolledFactorChannel;
import io.gravitee.am.repository.exceptions.TechnicalException;
import io.gravitee.am.resource.api.ResourceProvider;
import io.gravitee.am.resource.api.mfa.MFAChallenge;
import io.gravitee.am.resource.api.mfa.MFALink;
import io.gravitee.am.resource.api.mfa.MFAResourceProvider;
import io.gravitee.am.resource.api.mfa.MFAType;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CallFactorProvider
implements FactorProvider {
    private static final Logger logger = LoggerFactory.getLogger(CallFactorProvider.class);
    @Autowired
    private CallFactorConfiguration configuration;

    public Completable verify(FactorContext context) {
        String code = (String)context.getData("code", String.class);
        EnrolledFactor enrolledFactor = (EnrolledFactor)context.getData("enrolledFactor", EnrolledFactor.class);
        ResourceManager component = (ResourceManager)context.getComponent(ResourceManager.class);
        ResourceProvider provider = component.getResourceProvider(this.configuration.getGraviteeResource());
        if (provider instanceof MFAResourceProvider) {
            MFAResourceProvider mfaProvider = (MFAResourceProvider)provider;
            MFAChallenge challenge = new MFAChallenge(enrolledFactor.getChannel().getTarget(), code, context);
            return mfaProvider.verify(challenge);
        }
        return Completable.error((Throwable)new TechnicalException("Resource referenced can't be used for MultiFactor Authentication with type Call"));
    }

    public Single<Enrollment> enroll(String account) {
        return Single.just((Object)new Enrollment(this.configuration.countries()));
    }

    public Completable sendChallenge(FactorContext context) {
        EnrolledFactor enrolledFactor = (EnrolledFactor)context.getData("enrolledFactor", EnrolledFactor.class);
        ResourceManager component = (ResourceManager)context.getComponent(ResourceManager.class);
        ResourceProvider provider = component.getResourceProvider(this.configuration.getGraviteeResource());
        if (provider instanceof MFAResourceProvider) {
            MFAResourceProvider mfaProvider = (MFAResourceProvider)provider;
            MFALink link = new MFALink(MFAType.CALL, enrolledFactor.getChannel().getTarget(), context);
            return mfaProvider.send(link);
        }
        return Completable.error((Throwable)new TechnicalException("Resource referenced can't be used for MultiFactor Authentication  with type SMS"));
    }

    public boolean needChallengeSending() {
        return true;
    }

    public boolean checkSecurityFactor(EnrolledFactor factor) {
        boolean valid = false;
        if (factor != null) {
            EnrolledFactorChannel enrolledFactorChannel = factor.getChannel();
            if (enrolledFactorChannel == null || enrolledFactorChannel.getTarget() == null) {
                logger.warn("No phone number in form");
            } else {
                PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
                try {
                    Phonenumber.PhoneNumber phone = phoneNumberUtil.parse((CharSequence)enrolledFactorChannel.getTarget(), Phonenumber.PhoneNumber.CountryCodeSource.UNSPECIFIED.name());
                    for (String country : this.configuration.countries()) {
                        if (!phoneNumberUtil.isValidNumberForRegion(phone, country.toUpperCase(Locale.ROOT))) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        logger.warn("Invalid phone number");
                    }
                }
                catch (NumberParseException e) {
                    logger.warn("Invalid phone number", (Throwable)e);
                }
            }
        }
        return valid;
    }
}

