/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.am.factor.email.provider;

import io.gravitee.am.factor.api.Enrollment;
import io.gravitee.am.factor.api.FactorContext;
import io.gravitee.am.factor.api.OTPFactorProvider;
import io.gravitee.am.factor.email.EmailFactorConfiguration;
import io.gravitee.am.factor.utils.SharedSecret;
import io.gravitee.am.gateway.handler.common.email.EmailService;
import io.gravitee.am.gateway.handler.manager.resource.ResourceManager;
import io.gravitee.am.gateway.handler.root.service.user.UserService;
import io.gravitee.am.identityprovider.api.DefaultUser;
import io.gravitee.am.identityprovider.api.User;
import io.gravitee.am.model.Template;
import io.gravitee.am.model.factor.EnrolledFactor;
import io.gravitee.am.model.factor.EnrolledFactorChannel;
import io.gravitee.am.model.factor.EnrolledFactorSecurity;
import io.gravitee.am.repository.exceptions.TechnicalException;
import io.gravitee.am.resource.api.ResourceProvider;
import io.gravitee.am.resource.api.email.EmailSenderProvider;
import io.gravitee.am.service.utils.UserProfileUtils;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailFactorProvider
extends OTPFactorProvider {
    private static final Logger logger = LoggerFactory.getLogger(EmailFactorProvider.class);
    @Autowired
    private EmailFactorConfiguration configuration;

    public Completable verify(FactorContext context) {
        String code = (String)context.getData("code", String.class);
        EnrolledFactor enrolledFactor = (EnrolledFactor)context.getData("enrolledFactor", EnrolledFactor.class);
        return this.verifyOTP(enrolledFactor, this.configuration.getReturnDigits(), code);
    }

    public Single<Enrollment> enroll(String account) {
        return Single.fromCallable(() -> new Enrollment(SharedSecret.generate()));
    }

    public boolean checkSecurityFactor(EnrolledFactor factor) {
        boolean valid = false;
        if (factor != null) {
            EnrolledFactorSecurity securityFactor = factor.getSecurity();
            if (securityFactor == null || securityFactor.getValue() == null) {
                logger.warn("No shared secret in form");
            } else {
                EnrolledFactorChannel enrolledFactorChannel = factor.getChannel();
                if (enrolledFactorChannel == null || enrolledFactorChannel.getTarget() == null) {
                    logger.warn("No email address in form");
                } else {
                    try {
                        InternetAddress internetAddress = new InternetAddress(enrolledFactorChannel.getTarget());
                        internetAddress.validate();
                        valid = true;
                    }
                    catch (AddressException e) {
                        logger.warn("Email address is invalid", (Throwable)e);
                    }
                }
            }
        }
        return valid;
    }

    public boolean needChallengeSending() {
        return true;
    }

    public Completable sendChallenge(FactorContext context) {
        EnrolledFactor enrolledFactor = (EnrolledFactor)context.getData("enrolledFactor", EnrolledFactor.class);
        ResourceManager component = (ResourceManager)context.getComponent(ResourceManager.class);
        ResourceProvider provider = component.getResourceProvider(this.configuration.getGraviteeResource());
        if (provider instanceof EmailSenderProvider) {
            return this.generateCodeAndSendEmail(context, (EmailSenderProvider)provider, enrolledFactor);
        }
        return Completable.error((Throwable)new TechnicalException("Resource referenced can't be used for MultiFactor Authentication with type EMAIL"));
    }

    private Completable generateCodeAndSendEmail(FactorContext context, EmailSenderProvider provider, EnrolledFactor enrolledFactor) {
        logger.debug("Generating factor code of {} digits", (Object)this.configuration.getReturnDigits());
        try {
            UserService userService = (UserService)context.getComponent(UserService.class);
            EmailService emailService = (EmailService)context.getComponent(EmailService.class);
            if (enrolledFactor.getSecurity().getData("EXPIRATION_EPOCH", Long.class) != null && Instant.now().isAfter(Instant.ofEpochMilli((Long)enrolledFactor.getSecurity().getData("EXPIRATION_EPOCH", Long.class)))) {
                this.incrementMovingFactor(enrolledFactor);
            }
            Map params = context.getTemplateValues();
            params.put("code", this.generateOTP(enrolledFactor, this.configuration.getReturnDigits()));
            String recipient = enrolledFactor.getChannel().getTarget();
            Locale preferredLanguage = UserProfileUtils.preferredLanguage((io.gravitee.am.model.User)context.getUser(), (Locale)Locale.ENGLISH);
            EmailService.EmailWrapper emailWrapper = emailService.createEmail(Template.MFA_CHALLENGE, context.getClient(), Arrays.asList(recipient), params, preferredLanguage);
            return provider.sendMessage(emailWrapper.getEmail(), emailWrapper.isFromDefaultTemplate()).andThen((CompletableSource)Single.just((Object)enrolledFactor).flatMap(ef -> {
                ef.getSecurity().putData("EXPIRATION_EPOCH", (Object)emailWrapper.getExpireAt());
                return userService.addFactor(context.getUser().getId(), ef, (User)new DefaultUser(context.getUser()));
            }).ignoreElement());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error("Code generation fails", (Throwable)e);
            return Completable.error((Throwable)new TechnicalException("Code can't be sent"));
        }
        catch (Exception e) {
            logger.error("Email templating fails", (Throwable)e);
            return Completable.error((Throwable)new TechnicalException("Email can't be sent"));
        }
    }
}

