/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.am.factor.recovery.code.provider;

import io.gravitee.am.common.exception.mfa.InvalidCodeException;
import io.gravitee.am.common.utils.SecureRandomString;
import io.gravitee.am.factor.api.Enrollment;
import io.gravitee.am.factor.api.FactorContext;
import io.gravitee.am.factor.api.FactorProvider;
import io.gravitee.am.factor.api.RecoveryFactor;
import io.gravitee.am.factor.recovery.code.RecoveryCodeFactorConfiguration;
import io.gravitee.am.gateway.handler.root.service.user.UserService;
import io.gravitee.am.identityprovider.api.DefaultUser;
import io.gravitee.am.identityprovider.api.User;
import io.gravitee.am.model.Factor;
import io.gravitee.am.model.factor.EnrolledFactor;
import io.gravitee.am.model.factor.EnrolledFactorSecurity;
import io.gravitee.am.model.factor.FactorStatus;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RecoveryCodeFactorProvider
implements FactorProvider,
RecoveryFactor {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryCodeFactorProvider.class);
    @Autowired
    private RecoveryCodeFactorConfiguration configuration;

    public Completable sendChallenge(FactorContext context) {
        return Completable.complete();
    }

    public Completable verify(FactorContext context) {
        String code = (String)context.getData("code", String.class);
        EnrolledFactor enrolledFactor = (EnrolledFactor)context.getData("enrolledFactor", EnrolledFactor.class);
        List recoveryCodes = (List)enrolledFactor.getSecurity().getAdditionalData().get("RECOVERY_CODE");
        return Completable.create(emitter -> {
            if (recoveryCodes.contains(code)) {
                recoveryCodes.remove(code);
                enrolledFactor.getSecurity().setAdditionalData(Map.of("RECOVERY_CODE", recoveryCodes));
                emitter.onComplete();
            } else {
                emitter.onError((Throwable)new InvalidCodeException("Invalid recovery code"));
            }
        });
    }

    public Single<Enrollment> enroll(String account) {
        return Single.just((Object)new Enrollment(""));
    }

    public boolean checkSecurityFactor(EnrolledFactor securityFactor) {
        return true;
    }

    public boolean needChallengeSending() {
        return true;
    }

    public boolean useVariableFactorSecurity() {
        return true;
    }

    public Single<EnrolledFactorSecurity> generateRecoveryCode(FactorContext context) {
        Factor recoveryFactor = (Factor)context.getData("recoveryFactor", Factor.class);
        EnrolledFactor enrolledFactor = new EnrolledFactor();
        enrolledFactor.setFactorId(recoveryFactor.getId());
        enrolledFactor.setStatus(FactorStatus.PENDING_ACTIVATION);
        enrolledFactor.setCreatedAt(new Date());
        enrolledFactor.setUpdatedAt(enrolledFactor.getCreatedAt());
        return this.addRecoveryCodeFactor(context, enrolledFactor);
    }

    private Single<EnrolledFactorSecurity> addRecoveryCodeFactor(FactorContext context, EnrolledFactor enrolledFactor) {
        try {
            UserService userService = (UserService)context.getComponent(UserService.class);
            EnrolledFactorSecurity enrolledFactorSecurity = this.createEnrolledFactorSecurity();
            enrolledFactor.setSecurity(enrolledFactorSecurity);
            return userService.addFactor(context.getUser().getId(), enrolledFactor, (User)new DefaultUser(context.getUser())).map(__ -> enrolledFactorSecurity);
        }
        catch (Exception exception) {
            return Single.error((Throwable)exception);
        }
    }

    private EnrolledFactorSecurity createEnrolledFactorSecurity() {
        Map<String, List<String>> recoveryCode = Map.of("RECOVERY_CODE", this.recoveryCodes());
        return new EnrolledFactorSecurity("RECOVERY_CODE", Integer.toString(this.configuration.getDigit()), recoveryCode);
    }

    private List<String> recoveryCodes() {
        int length = this.configuration.getDigit();
        int count = this.configuration.getCount();
        if (length <= 0 || count <= 0) {
            throw new IllegalArgumentException("Configuration cannot be used for recovery code. Either number of digits or number of recovery code is 0 or negative.");
        }
        logger.debug("Generating recovery code of {} digits", (Object)length);
        return SecureRandomString.randomAlphaNumeric((int)length, (int)count);
    }
}

