/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginEvent;
import io.gravitee.plugin.core.api.PluginHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PluginEventListener
extends AbstractService
implements EventListener<PluginEvent, Plugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginEventListener.class);
    private static final List<String> pluginPriority = Arrays.asList("cluster", "cache", "repository", "alert", "cockpit");
    @Value(value="${plugins.failOnDuplicate:true}")
    private boolean failOnDuplicate;
    @Autowired
    private Collection<PluginHandler> pluginHandlers;
    @Autowired
    private EventManager eventManager;
    private final Map<PluginKey, Plugin> plugins = new ConcurrentHashMap<PluginKey, Plugin>();

    public void onEvent(Event<PluginEvent, Plugin> event) {
        switch ((PluginEvent)event.type()) {
            case DEPLOYED: {
                LOGGER.debug("Receive an event for plugin {} [{}]", (Object)((Plugin)event.content()).id(), (Object)event.type());
                this.addPlugin((Plugin)event.content());
                break;
            }
            case ENDED: {
                LOGGER.info("All plugins have been loaded. Installing...");
                this.deployPlugins();
            }
        }
    }

    private void addPlugin(Plugin plugin) {
        PluginKey pluginKey = new PluginKey(plugin.id(), plugin.type());
        if (this.plugins.containsKey(pluginKey)) {
            Plugin installed = this.plugins.get(pluginKey);
            if (this.failOnDuplicate) {
                throw new IllegalStateException(String.format("Plugin '%s' [%s] is already loaded [%s]", plugin.id(), plugin.manifest().version(), installed.manifest().version()));
            }
            LOGGER.warn("Plugin '{}' [{}] is already loaded [{}]", new Object[]{plugin.id(), plugin.manifest().version(), installed.manifest().version()});
        } else {
            this.plugins.put(pluginKey, plugin);
        }
    }

    private void deployPlugins() {
        HashMap resolvedDependencies = new HashMap();
        List<Plugin> sortedByPriority = this.plugins.values().stream().sorted(Comparator.comparingInt(o -> o.manifest().priority()).thenComparing(new PluginComparator())).collect(Collectors.toList());
        this.plugins.values().forEach(p -> this.plugins.values().forEach(other -> {
            if (p.manifest().dependencies().stream().anyMatch(d -> d.matches((Plugin)other))) {
                resolvedDependencies.computeIfAbsent(p.type() + p.id(), s -> new ArrayList()).add(other);
            }
        }));
        ArrayList deployedPlugins = new ArrayList(this.plugins.size());
        sortedByPriority.forEach(plugin -> this.deployPlugin((Plugin)plugin, resolvedDependencies, deployedPlugins));
    }

    private void deployPlugin(Plugin plugin, Map<String, List<Plugin>> resolvedDependencies, List<Plugin> deployedPlugins) {
        if (deployedPlugins.contains(plugin)) {
            return;
        }
        resolvedDependencies.getOrDefault(plugin.type() + plugin.id(), Collections.emptyList()).forEach(dependencyPlugin -> this.deployPlugin((Plugin)dependencyPlugin, resolvedDependencies, deployedPlugins));
        LOGGER.debug("Installing {} plugins...", (Object)plugin.id());
        this.pluginHandlers.stream().filter(pluginHandler -> pluginHandler.canHandle(plugin)).forEach(pluginHandler -> {
            LOGGER.debug("Plugin {} has been managed by {}", (Object)plugin.id(), pluginHandler.getClass());
            pluginHandler.handle(plugin);
        });
        deployedPlugins.add(plugin);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, PluginEvent.class);
    }

    public void setFailOnDuplicate(boolean failOnDuplicate) {
        this.failOnDuplicate = failOnDuplicate;
    }

    private static class PluginComparator
    implements Comparator<Plugin> {
        private PluginComparator() {
        }

        @Override
        public int compare(Plugin o1, Plugin o2) {
            Integer pos1 = pluginPriority.indexOf(o1.type());
            Integer pos2 = pluginPriority.indexOf(o2.type());
            if (pos1 >= 0) {
                if (pos2 >= 0) {
                    return pos1.compareTo(pos2);
                }
                return -1;
            }
            if (pos2 >= 0) {
                return 1;
            }
            return 0;
        }
    }

    private static class PluginKey {
        private final String id;
        private final String type;

        public PluginKey(String id, String type) {
            this.id = id;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginKey pluginKey = (PluginKey)o;
            if (!this.id.equals(pluginKey.id)) {
                return false;
            }
            return this.type == pluginKey.type;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

