/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import java.util.ArrayList;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

public class PluginRegistryConfiguration
implements InitializingBean {
    private static final String PLUGIN_WORK_DIR_PROPERTY = "plugins.workDir";
    private static final String PLUGIN_PATH_PROPERTY = "plugins.path[%s]";
    @Value(value="${plugins.path:${gravitee.home}/plugins}")
    private String defaultPluginPath;
    private String[] pluginsPath;
    @Autowired
    private Environment environment;
    private String pluginWorkDir;

    public void afterPropertiesSet() {
        String key = String.format(PLUGIN_PATH_PROPERTY, 0);
        ArrayList<String> paths = new ArrayList<String>();
        while (this.environment.containsProperty(key)) {
            String pathProperty = this.environment.getProperty(key);
            paths.add(pathProperty);
            key = String.format(PLUGIN_PATH_PROPERTY, paths.size());
        }
        if (paths.isEmpty()) {
            paths.add(this.defaultPluginPath);
        }
        this.pluginsPath = paths.toArray(new String[0]);
        this.pluginWorkDir = this.environment.getProperty(PLUGIN_WORK_DIR_PROPERTY);
    }

    public String[] getPluginsPath() {
        return this.pluginsPath;
    }

    public void setPluginsPath(String[] pluginsPath) {
        this.pluginsPath = pluginsPath;
    }

    public String getPluginWorkDir() {
        return this.pluginWorkDir;
    }

    public void setPluginWorkDir(String pluginWorkDir) {
        this.pluginWorkDir = pluginWorkDir;
    }
}

