/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.internal;

import com.google.common.base.Predicate;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginConfigurationResolver;
import java.net.URL;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

public class ReflectionBasedPluginConfigurationResolver
implements PluginConfigurationResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(ReflectionBasedPluginConfigurationResolver.class);
    @Autowired
    private PluginClassLoaderFactory pluginClassLoaderFactory;

    @Override
    public Set<Class<?>> resolve(Plugin plugin) {
        try {
            Class<?> pluginClass = this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin).loadClass(plugin.clazz());
            this.LOGGER.debug("Looking for configurations for plugin {} in package {}", (Object)pluginClass.getName(), (Object)pluginClass.getPackage().getName());
            Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().addClassLoader(pluginClass.getClassLoader()).setExpandSuperTypes(false).setUrls(new URL[]{ClasspathHelper.forClass(pluginClass, (ClassLoader[])new ClassLoader[]{pluginClass.getClassLoader()})}).setScanners(new Scanner[]{new SubTypesScanner(false), new TypeAnnotationsScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{pluginClass.getPackage().getName()})));
            return reflections.getTypesAnnotatedWith(Configuration.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

