/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.core.spring;

import io.gravitee.plugin.core.api.PluginHandler;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PluginHandlerBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(PluginHandlerBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.LOGGER.info("Loading plugin handlers");
        HashSet pluginHandlers = new HashSet(SpringFactoriesLoader.loadFactoryNames(PluginHandler.class, (ClassLoader)beanFactory.getBeanClassLoader()));
        this.LOGGER.info("Find {} plugin handler(s):", (Object)pluginHandlers.size());
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        for (String pluginHandlerClass : pluginHandlers) {
            try {
                Class instanceClass = ClassUtils.forName((String)pluginHandlerClass, (ClassLoader)beanFactory.getBeanClassLoader());
                Assert.isAssignable(PluginHandler.class, (Class)instanceClass);
                PluginHandler pluginHandler = (PluginHandler)this.createInstance(instanceClass);
                defaultListableBeanFactory.registerBeanDefinition(pluginHandler.getClass().getName(), (BeanDefinition)new RootBeanDefinition(pluginHandler.getClass().getName()));
                this.LOGGER.info("\t{}", (Object)pluginHandler.getClass().getName());
            }
            catch (Exception ex) {
                this.LOGGER.error("Unable to instantiate plugin handler: {}", (Throwable)ex);
                throw new IllegalStateException("Unable to instantiate plugin handler: " + pluginHandlerClass, ex);
            }
        }
    }

    private <T> T createInstance(Class<T> clazz) throws Exception {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            this.LOGGER.error("Unable to instantiate class: {}", (Throwable)ex);
            throw ex;
        }
    }
}

