/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.resource.cache.redis;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.resource.cache.api.Cache;
import io.gravitee.resource.cache.api.CacheResource;
import io.gravitee.resource.cache.redis.RedisDelegate;
import io.gravitee.resource.cache.redis.configuration.HostAndPort;
import io.gravitee.resource.cache.redis.configuration.RedisCacheResourceConfiguration;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCacheResource
extends CacheResource<RedisCacheResourceConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(RedisCacheResource.class);
    private final StringRedisSerializer stringSerializer = new StringRedisSerializer();
    private RedisCacheManager redisCacheManager;

    protected void doStart() throws Exception {
        super.doStart();
        this.logger.debug("Create redis cache manager");
        try {
            RedisCacheConfiguration conf = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.stringSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.stringSerializer)).entryTtl(Duration.ofSeconds(((RedisCacheResourceConfiguration)this.configuration()).getTimeToLiveSeconds()));
            this.redisCacheManager = RedisCacheManager.builder((RedisConnectionFactory)this.getConnectionFactory()).cacheDefaults(conf).build();
        }
        catch (Throwable e) {
            this.logger.error("Cannot create redis cache manager", e);
        }
    }

    public String keySeparator() {
        return ":";
    }

    public Cache getCache(GenericExecutionContext ctx) {
        return this.getCache(ctx.getAttributes());
    }

    public Cache getCache(ExecutionContext executionContext) {
        return this.getCache(executionContext.getAttributes());
    }

    private Cache getCache(Map<String, Object> contextAttributes) {
        return new RedisDelegate(this.redisCacheManager.getCache("gravitee:"), contextAttributes, (RedisSerializer)this.stringSerializer, (int)((RedisCacheResourceConfiguration)this.configuration()).getTimeToLiveSeconds(), ((RedisCacheResourceConfiguration)this.configuration()).isReleaseCache());
    }

    private LettucePoolingClientConfiguration buildLettuceClientConfiguration() {
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
        builder.commandTimeout(Duration.ofMillis(((RedisCacheResourceConfiguration)this.configuration()).getTimeout()));
        if (((RedisCacheResourceConfiguration)this.configuration()).isUseSsl()) {
            builder.useSsl();
        }
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(((RedisCacheResourceConfiguration)this.configuration()).getMaxTotal());
        poolConfig.setBlockWhenExhausted(false);
        builder.poolConfig(poolConfig);
        return builder.build();
    }

    public RedisConnectionFactory getConnectionFactory() {
        LettuceConnectionFactory lettuceConnectionFactory;
        Boolean hasSentinelEnabled = ((RedisCacheResourceConfiguration)this.configuration()).getSentinel().isEnabled();
        if (hasSentinelEnabled.equals(Boolean.TRUE) || hasSentinelEnabled == null && ((RedisCacheResourceConfiguration)this.configuration()).isSentinelMode()) {
            List<HostAndPort> sentinelNodes = ((RedisCacheResourceConfiguration)this.configuration()).getSentinel().getNodes();
            RedisSentinelConfiguration sentinelConfiguration = new RedisSentinelConfiguration();
            sentinelConfiguration.master(((RedisCacheResourceConfiguration)this.configuration()).getSentinel().getMasterId());
            sentinelNodes.forEach(hostAndPort -> sentinelConfiguration.sentinel(hostAndPort.getHost(), Integer.valueOf(hostAndPort.getPort())));
            sentinelConfiguration.setSentinelPassword(((RedisCacheResourceConfiguration)this.configuration()).getSentinel().getPassword());
            sentinelConfiguration.setPassword(((RedisCacheResourceConfiguration)this.configuration()).getPassword());
            lettuceConnectionFactory = new LettuceConnectionFactory(sentinelConfiguration, (LettuceClientConfiguration)this.buildLettuceClientConfiguration());
        } else {
            RedisStandaloneConfiguration standaloneConfiguration = new RedisStandaloneConfiguration();
            standaloneConfiguration.setHostName(((RedisCacheResourceConfiguration)this.configuration()).getStandalone().getHost());
            standaloneConfiguration.setPort(((RedisCacheResourceConfiguration)this.configuration()).getStandalone().getPort());
            standaloneConfiguration.setPassword(((RedisCacheResourceConfiguration)this.configuration()).getPassword());
            lettuceConnectionFactory = new LettuceConnectionFactory(standaloneConfiguration, (LettuceClientConfiguration)this.buildLettuceClientConfiguration());
        }
        lettuceConnectionFactory.afterPropertiesSet();
        return lettuceConnectionFactory;
    }
}

