/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.resource.cache.redis;

import io.gravitee.resource.cache.api.Cache;
import io.gravitee.resource.cache.api.Element;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisDelegate
implements Cache {
    private final Logger logger = LoggerFactory.getLogger(RedisDelegate.class);
    private final org.springframework.cache.Cache cache;
    private final int timeToLiveSeconds;
    private final RedisSerializer serializer;
    private final Map<String, Object> contextAttributes;
    private boolean releaseCache;

    public RedisDelegate(org.springframework.cache.Cache cache, Map<String, Object> contextAttributes, RedisSerializer serializer, int timeToLiveSeconds, boolean releaseCache) {
        this.cache = cache;
        this.contextAttributes = contextAttributes;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.serializer = serializer;
        this.releaseCache = releaseCache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache.getNativeCache();
    }

    public Element get(final Object key) {
        this.logger.debug("Find in cache {}", key);
        try {
            RedisCacheWriter redisCacheWriter = (RedisCacheWriter)this.getNativeCache();
            byte[] bytes = redisCacheWriter.get(this.getName(), this.buildKey(key));
            if (bytes != null) {
                final Object value = this.serializer.deserialize(bytes);
                return new Element(){

                    public Object key() {
                        return key;
                    }

                    public Object value() {
                        return value;
                    }
                };
            }
            return null;
        }
        catch (Throwable e) {
            this.logger.error("Cannot get element in cache", e);
            this.logger.debug("Not found {}", key);
            return null;
        }
    }

    public void put(Element element) {
        this.logger.debug("Put in cache {}", element.key());
        try {
            int ttl = this.timeToLiveSeconds;
            if (ttl == 0 && element.timeToLive() > 0 || ttl > 0 && element.timeToLive() > 0 && ttl > element.timeToLive()) {
                ttl = element.timeToLive();
            }
            RedisCacheWriter redisCacheWriter = (RedisCacheWriter)this.getNativeCache();
            redisCacheWriter.put(this.getName(), this.buildKey(element.key()), this.serializer.serialize(element.value()), Duration.ofSeconds(ttl));
        }
        catch (Throwable e) {
            this.logger.error("Cannot put element in cache", e);
        }
    }

    private byte[] buildKey(Object key) {
        String allKey = this.getName() + key;
        if (this.releaseCache) {
            allKey = allKey + ":" + this.contextAttributes.get("gravitee.attribute.api.deployed-at");
        }
        return this.serializer.serialize((Object)allKey);
    }

    public void evict(Object o) {
        this.cache.evict(o);
    }

    public void clear() {
        this.cache.clear();
    }
}

