/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import com.google.protobuf.Message;
import io.greptime.common.util.Ensures;
import io.greptime.rpc.MethodDescriptor;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public interface MarshallerRegistry {
    default public String getMethodName(Class<? extends Message> reqCls, MethodDescriptor.MethodType methodType) {
        return this.getMethodName(reqCls, this.supportedMethodType(methodType));
    }

    public String getMethodName(Class<? extends Message> var1, MethodDescriptor.MethodType var2);

    public Set<MethodDescriptor> getAllMethodDescriptors();

    default public Map<String, Double> getAllMethodsLimitPercent() {
        return this.getAllMethodDescriptors().stream().filter(mth -> mth.getLimitPercent() > 0.0).collect(Collectors.toMap(MethodDescriptor::getName, MethodDescriptor::getLimitPercent));
    }

    public Message getDefaultRequestInstance(Class<? extends Message> var1);

    public Message getDefaultResponseInstance(Class<? extends Message> var1);

    public void registerMarshaller(MethodDescriptor var1, Class<? extends Message> var2, Message var3, Message var4);

    default public MethodDescriptor.MethodType supportedMethodType(MethodDescriptor.MethodType mt) {
        switch (mt) {
            case UNARY: {
                return MethodDescriptor.MethodType.UNARY;
            }
            case CLIENT_STREAMING: {
                return MethodDescriptor.MethodType.CLIENT_STREAMING;
            }
            case SERVER_STREAMING: {
                return MethodDescriptor.MethodType.SERVER_STREAMING;
            }
        }
        throw new UnsupportedOperationException(mt.name());
    }

    public static enum DefaultMarshallerRegistry implements MarshallerRegistry
    {
        INSTANCE;

        private final Map<Class<? extends Message>, Map<MethodDescriptor.MethodType, MethodDescriptor>> methods = new ConcurrentHashMap<Class<? extends Message>, Map<MethodDescriptor.MethodType, MethodDescriptor>>();
        private final Map<Class<? extends Message>, Message> requests = new ConcurrentHashMap<Class<? extends Message>, Message>();
        private final Map<Class<? extends Message>, Message> responses = new ConcurrentHashMap<Class<? extends Message>, Message>();

        @Override
        public String getMethodName(Class<? extends Message> reqCls, MethodDescriptor.MethodType methodType) {
            Map<MethodDescriptor.MethodType, MethodDescriptor> methods = this.methods.get(reqCls);
            Ensures.ensureNonNull(methods, (String)("Could not find method by " + reqCls));
            MethodDescriptor md = methods.get(methodType);
            Ensures.ensureNonNull((Object)md, (String)("Could not find method by " + reqCls + " and " + methodType));
            return md.getName();
        }

        @Override
        public Set<MethodDescriptor> getAllMethodDescriptors() {
            return this.methods.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
        }

        @Override
        public Message getDefaultRequestInstance(Class<? extends Message> reqCls) {
            return (Message)Ensures.ensureNonNull((Object)this.requests.get(reqCls), (String)("Could not find request instance by " + reqCls));
        }

        @Override
        public Message getDefaultResponseInstance(Class<? extends Message> reqCls) {
            return (Message)Ensures.ensureNonNull((Object)this.responses.get(reqCls), (String)("Could not find response instance by " + reqCls));
        }

        @Override
        public void registerMarshaller(MethodDescriptor method, Class<? extends Message> reqCls, Message defaultReqIns, Message defaultRespIns) {
            this.methods.computeIfAbsent(reqCls, cls -> new ConcurrentHashMap()).put(method.getType(), method);
            this.requests.put(reqCls, defaultReqIns);
            this.responses.put(reqCls, defaultRespIns);
        }
    }
}

