/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file;

import io.gridgo.connector.file.FileConsumer;
import io.gridgo.connector.file.FileProducer;
import io.gridgo.connector.file.support.engines.BasicFileProducerEngine;
import io.gridgo.connector.file.support.engines.DisruptorFileProducerEngine;
import io.gridgo.connector.file.support.engines.FileProducerEngine;
import io.gridgo.connector.file.support.exceptions.FileInitException;
import io.gridgo.connector.file.support.limit.AutoIncrementedFileLimitStrategy;
import io.gridgo.connector.file.support.limit.FileLimitStrategy;
import io.gridgo.connector.file.support.limit.NoLimitStrategy;
import io.gridgo.connector.file.support.limit.RotatingFileLimitStrategy;
import io.gridgo.connector.impl.AbstractConnector;
import io.gridgo.connector.support.annotations.ConnectorEndpoint;
import java.io.IOException;
import java.util.Optional;

@ConnectorEndpoint(scheme="file", syntax="[{engine}:]//{path}")
public class FileConnector
extends AbstractConnector {
    public static final int DEFAULT_RINGBUFFER_SIZE = 1024;
    public static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private static final long DEFAULT_LIMIT = -1L;
    private static final int DEFAULT_COUNT = 10;
    private FileProducerEngine engine;
    private FileLimitStrategy limitStrategy;

    private FileProducerEngine createBasicProducer(String format, int bufferSize, boolean lengthPrepend) {
        return new BasicFileProducerEngine(this.getContext(), format, bufferSize, lengthPrepend);
    }

    private FileProducerEngine createDisruptorProducer(String format, int bufferSize, boolean lengthPrepend) {
        String strRingBufferSize = this.getParam("ringBufferSize");
        String strMaxBatchSize = this.getParam("maxBatchSize");
        int ringBufferSize = strRingBufferSize != null ? Integer.parseInt(strRingBufferSize) : 1024;
        int maxBatchSize = strMaxBatchSize != null ? Integer.parseInt(strMaxBatchSize) : 1000;
        boolean batchingEnabled = "true".equals(this.getParam("batchingEnabled"));
        return new DisruptorFileProducerEngine(this.getContext(), format, bufferSize, ringBufferSize, batchingEnabled, maxBatchSize, lengthPrepend);
    }

    private FileLimitStrategy createLimitStrategy(String limitStrategy, String path, String mode, long limit, int count, boolean deleteOnStartup, boolean deleteOnShutdown, boolean override) {
        try {
            if (limitStrategy == null) {
                return new NoLimitStrategy(path, mode, deleteOnStartup, deleteOnShutdown, override);
            }
            if (limitStrategy.equals("rotate")) {
                return new RotatingFileLimitStrategy(path, mode, limit, count, deleteOnStartup, deleteOnShutdown, override);
            }
            if (limitStrategy.equals("autoincrement")) {
                return new AutoIncrementedFileLimitStrategy(path, mode, limit, deleteOnStartup, deleteOnShutdown, override);
            }
        }
        catch (IOException ex) {
            throw new FileInitException("Cannot create limit strategy", ex);
        }
        throw new UnsupportedOperationException("Limit Strategy is unsupported: " + limitStrategy);
    }

    protected void onInit() {
        int bufferSize;
        String engineName = this.getPlaceholder("engine");
        String format = this.getParam("format", "raw");
        boolean lengthPrepend = !"false".equals(this.getParam("lengthPrepend"));
        boolean producerOnly = "true".equals(this.getParam("producerOnly"));
        String strBufferSize = this.getParam("bufferSize");
        int n = bufferSize = strBufferSize != null ? Integer.parseInt(strBufferSize) : 0x100000;
        if ("disruptor".equals(engineName)) {
            this.engine = this.createDisruptorProducer(format, bufferSize, lengthPrepend);
        } else if (engineName == null || "basic".equals(engineName)) {
            this.engine = this.createBasicProducer(format, bufferSize, lengthPrepend);
        } else {
            throw new IllegalArgumentException("Unsupported file producer engine: " + engineName);
        }
        String path = this.getPlaceholder("path");
        String mode = this.getParam("mode", "rw");
        boolean override = "true".equals(this.getParam("override"));
        boolean deleteOnStartup = "true".equals(this.getParam("deleteOnStartup"));
        boolean deleteOnShutdown = "true".equals(this.getParam("deleteOnShutdown"));
        String strLimit = this.getParam("limitSize");
        long limit = strLimit != null ? Long.parseLong(strLimit) : -1L;
        String strCount = this.getParam("rotationCount");
        int count = strCount != null ? Integer.parseInt(strCount) : 10;
        String strLimitStrategy = this.getParam("limitStrategy");
        this.limitStrategy = this.createLimitStrategy(strLimitStrategy, path, mode, limit, count, deleteOnStartup, deleteOnShutdown, override);
        FileProducer producer = new FileProducer(this.getContext(), path, this.engine);
        this.producer = Optional.of(producer);
        if (!producerOnly) {
            this.consumer = Optional.of(new FileConsumer(this.getContext(), path, format, bufferSize, lengthPrepend, this.limitStrategy));
        }
    }

    protected void onStart() {
        try {
            this.limitStrategy.start();
        }
        catch (IOException e) {
            throw new FileInitException("Cannot start limit strategy", e);
        }
        this.engine.setLimitStrategy(this.limitStrategy);
        this.engine.start();
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
        this.engine.stop();
        try {
            this.limitStrategy.stop();
        }
        catch (IOException e) {
            throw new FileInitException("Cannot stop limit strategy", e);
        }
    }
}

