/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file;

import io.gridgo.connector.file.support.engines.FileConsumerEngine;
import io.gridgo.connector.file.support.engines.LengthPrependedFileConsumerEngine;
import io.gridgo.connector.file.support.engines.SimpleFileConsumerEngine;
import io.gridgo.connector.file.support.limit.FileLimitStrategy;
import io.gridgo.connector.impl.AbstractConsumer;
import io.gridgo.connector.support.config.ConnectorContext;
import io.gridgo.framework.support.Message;

public class FileConsumer
extends AbstractConsumer {
    private String path;
    private String format;
    private boolean lengthPrepend;
    private byte[] buffer;
    private boolean hasRotation;
    private int count;
    private FileLimitStrategy limitStrategy;

    public FileConsumer(ConnectorContext context, String path, String format, int bufferSize, boolean lengthPrepend, FileLimitStrategy limitStrategy) {
        super(context);
        this.path = path;
        this.format = format;
        this.lengthPrepend = lengthPrepend;
        this.buffer = new byte[bufferSize];
        this.limitStrategy = limitStrategy;
    }

    protected String generateName() {
        return "consumer.file." + this.path;
    }

    protected void onStart() {
        this.readAndPublish();
    }

    protected void onStop() {
    }

    public void publishMessage(Message msg) {
        this.publish(msg, null);
    }

    private void readAndPublish() {
        FileConsumerEngine engine = this.lengthPrepend ? new LengthPrependedFileConsumerEngine(this) : new SimpleFileConsumerEngine(this);
        this.getContext().getConsumerExecutionStrategy().ifPresentOrElse(strategy -> strategy.execute(engine::readAndPublish), engine::readAndPublish);
    }

    public String getPath() {
        return this.path;
    }

    public String getFormat() {
        return this.format;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public boolean isHasRotation() {
        return this.hasRotation;
    }

    public int getCount() {
        return this.count;
    }

    public FileLimitStrategy getLimitStrategy() {
        return this.limitStrategy;
    }
}

