/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.engines;

import io.gridgo.bean.BElement;
import io.gridgo.connector.file.support.engines.FileProducerEngine;
import io.gridgo.connector.file.support.limit.FileLimitStrategy;
import io.gridgo.connector.impl.AbstractProducer;
import io.gridgo.connector.support.config.ConnectorContext;
import io.gridgo.framework.support.Message;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.joo.promise4j.Deferred;
import org.joo.promise4j.Promise;
import org.joo.promise4j.impl.CompletableDeferredObject;

public class BasicFileProducerEngine
extends AbstractProducer
implements FileProducerEngine {
    private String format;
    private FileLimitStrategy limitStrategy;
    private boolean lengthPrepend;
    private long totalSentBytes;
    private ByteBuffer buffer;

    public BasicFileProducerEngine(ConnectorContext context, String format, int bufferSize, boolean lengthPrepend) {
        super(context);
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.format = format;
        this.lengthPrepend = lengthPrepend;
    }

    public Promise<Message, Exception> call(Message request) {
        throw new UnsupportedOperationException("File doesn't support call");
    }

    private void doSend(Message message, CompletableDeferredObject<Message, Exception> deferred) {
        try {
            FileChannel channel = this.limitStrategy.getFileChannel();
            long currentSent = this.writeToFile((BElement)message.getPayload().toBArray(), this.lengthPrepend, this.buffer, channel);
            this.totalSentBytes += currentSent;
            this.limitStrategy.putBytes(currentSent);
        }
        catch (Exception ex) {
            this.ack((Deferred)deferred, ex);
            return;
        }
        this.ack((Deferred)deferred);
    }

    protected String generateName() {
        return "basic";
    }

    public boolean isCallSupported() {
        return false;
    }

    protected void onStart() {
        this.totalSentBytes = 0L;
    }

    protected void onStop() {
    }

    public void send(Message message) {
        this.doSend(message, null);
    }

    public Promise<Message, Exception> sendWithAck(Message message) {
        CompletableDeferredObject deferred = new CompletableDeferredObject();
        this.doSend(message, (CompletableDeferredObject<Message, Exception>)deferred);
        return deferred.promise();
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void setLimitStrategy(FileLimitStrategy limitStrategy) {
        this.limitStrategy = limitStrategy;
    }

    @Override
    public long getTotalSentBytes() {
        return this.totalSentBytes;
    }
}

