/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.engines;

import io.gridgo.bean.BElement;
import io.gridgo.connector.file.support.engines.FileProducerEngine;
import io.gridgo.connector.file.support.limit.FileLimitStrategy;
import io.gridgo.connector.impl.SingleThreadSendingProducer;
import io.gridgo.connector.support.config.ConnectorContext;
import io.gridgo.framework.support.Message;
import io.gridgo.framework.support.impl.MultipartMessage;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import org.joo.promise4j.Promise;

public class DisruptorFileProducerEngine
extends SingleThreadSendingProducer
implements FileProducerEngine {
    private boolean lengthPrepend;
    private String format;
    private long totalSentBytes;
    private FileLimitStrategy limitStrategy;
    private ByteBuffer buffer;

    public DisruptorFileProducerEngine(ConnectorContext context, String format, int bufferSize, int ringBufferSize, boolean batchingEnabled, int maxBatchSize, boolean lengthPrepend) {
        super(context, ringBufferSize, batchingEnabled, maxBatchSize);
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.format = format;
        this.lengthPrepend = lengthPrepend;
    }

    protected Message accumulateBatch(Collection<Message> messages) {
        return new MultipartMessage(messages);
    }

    public Promise<Message, Exception> call(Message request) {
        throw new UnsupportedOperationException("File doesn't support call");
    }

    protected void executeSendOnSingleThread(Message message) throws Exception {
        FileChannel channel = this.limitStrategy.getFileChannel();
        long currentSent = this.writeToFile((BElement)message.getPayload().toBArray(), this.lengthPrepend, this.buffer, channel);
        this.totalSentBytes += currentSent;
        this.limitStrategy.putBytes(currentSent);
    }

    protected String generateName() {
        return "disruptor";
    }

    public boolean isCallSupported() {
        return false;
    }

    protected void onStart() {
        this.totalSentBytes = 0L;
        super.onStart();
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public long getTotalSentBytes() {
        return this.totalSentBytes;
    }

    @Override
    public void setLimitStrategy(FileLimitStrategy limitStrategy) {
        this.limitStrategy = limitStrategy;
    }
}

