/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.engines;

import io.gridgo.bean.BElement;
import io.gridgo.bean.BValue;
import io.gridgo.connector.support.FormattedMarshallable;
import io.gridgo.connector.support.exceptions.UnsupportedFormatException;

public interface FileConsumerEngine
extends FormattedMarshallable {
    default public BElement deserialize(byte[] responseBody, int length) {
        if (responseBody == null) {
            return null;
        }
        String format = this.getFormat();
        if (format == null || format.equals("json")) {
            return BElement.ofJson((String)new String(responseBody, 0, length));
        }
        if (format.equals("xml")) {
            return BElement.ofXml((String)new String(responseBody, 0, length));
        }
        if (format.equals("string")) {
            return BValue.of((Object)responseBody);
        }
        if (format.equals("raw")) {
            return BElement.ofBytes((byte[])responseBody);
        }
        throw new UnsupportedFormatException(format);
    }

    public void readAndPublish();
}

