/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.engines;

import io.gridgo.bean.BElement;
import io.gridgo.connector.file.FileConsumer;
import io.gridgo.connector.file.support.engines.FileConsumerEngine;
import io.gridgo.connector.file.support.exceptions.FileReadException;
import io.gridgo.connector.file.support.exceptions.LengthMismatchException;
import io.gridgo.framework.support.Message;
import io.gridgo.framework.support.impl.MultipartMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthPrependedFileConsumerEngine
implements FileConsumerEngine {
    private static final Logger log = LoggerFactory.getLogger(LengthPrependedFileConsumerEngine.class);
    private FileConsumer fileConsumer;

    public LengthPrependedFileConsumerEngine(FileConsumer fileConsumer) {
        this.fileConsumer = fileConsumer;
    }

    public String getFormat() {
        return this.fileConsumer.getFormat();
    }

    @Override
    public void readAndPublish() {
        byte[] buffer = this.fileConsumer.getBuffer();
        try {
            this.fileConsumer.getLimitStrategy().readWith(raf -> this.readAndPublish(buffer, raf));
        }
        catch (IOException ex) {
            log.error("Exception caught when processing file", (Throwable)ex);
            throw new FileReadException(ex);
        }
    }

    private void readAndPublish(byte[] buffer, RandomAccessFile randomAccessFile) throws IOException {
        int length;
        while ((length = this.tryGetLength(randomAccessFile)) != -1) {
            int read;
            if (length > buffer.length) {
                log.warn("Buffer overflow detected. Limit: %d. Required: %d", (Object)buffer.length, (Object)length);
                buffer = new byte[length];
            }
            if ((read = randomAccessFile.read(buffer, 0, length)) != length) {
                throw new LengthMismatchException(length, read);
            }
            BElement payload = this.deserialize(buffer, length);
            Message msg = Message.parse((BElement)payload);
            if (msg instanceof MultipartMessage) {
                Message[] messages;
                for (Message message : messages = ((MultipartMessage)msg).buildOriginalMessages()) {
                    this.fileConsumer.publishMessage(message);
                }
                continue;
            }
            this.fileConsumer.publishMessage(msg);
        }
    }

    private int tryGetLength(RandomAccessFile randomAccessFile) throws IOException {
        try {
            return randomAccessFile.readInt();
        }
        catch (EOFException ex) {
            return -1;
        }
    }
}

