/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.limit;

import io.gridgo.connector.file.support.limit.AbstractFileLimitStrategy;
import io.gridgo.connector.file.support.limit.RandomAccessFileHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public class AutoIncrementedFileLimitStrategy
extends AbstractFileLimitStrategy {
    private String basePath;
    private String mode;
    private long limit;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private long written = -1L;
    private LinkedList<File> fileList;
    private boolean deleteOnStartup;
    private boolean deleteOnShutdown;
    private boolean override;

    public AutoIncrementedFileLimitStrategy(String basePath, String mode, long limit, boolean deleteOnStartup, boolean deleteOnShutdown, boolean override) {
        this.basePath = basePath;
        this.mode = mode;
        this.limit = limit;
        this.deleteOnStartup = deleteOnStartup;
        this.deleteOnShutdown = deleteOnShutdown;
        this.override = override;
    }

    private void closeFile() throws IOException {
        this.raf.close();
    }

    private void deleteFiles() {
        for (File file : this.fileList) {
            this.deleteFile(file);
        }
    }

    private void increment() throws IOException {
        this.closeFile();
        int last = this.fileList.size();
        File file = new File(this.basePath + "." + last);
        this.deleteFile(file);
        this.fileList.add(file);
        this.resetFile();
    }

    private LinkedList<File> initFiles() {
        File file;
        LinkedList<File> files = new LinkedList<File>();
        files.add(new File(this.basePath));
        int i = 0;
        while ((file = new File(this.basePath + "." + i)).exists()) {
            files.add(file);
            ++i;
        }
        return files;
    }

    @Override
    public void putBytes(long bytes) throws IOException {
        this.written += bytes;
        if (this.limit > 0L && this.written > this.limit) {
            this.increment();
        }
    }

    @Override
    public void readWith(RandomAccessFileHandler consumer) throws IOException {
        for (File file : this.fileList) {
            try (RandomAccessFile theRaf = new RandomAccessFile(file, "r");){
                consumer.process(theRaf);
            }
        }
    }

    private void resetFile() throws IOException {
        this.raf = new RandomAccessFile(this.fileList.getLast(), this.mode);
        if (!this.override) {
            long length = this.raf.length();
            this.raf.seek(length);
            this.written = length;
        } else {
            this.written = 0L;
        }
        this.fileChannel = this.raf.getChannel();
    }

    @Override
    public void start() throws IOException {
        this.fileList = this.initFiles();
        if (this.deleteOnStartup) {
            this.deleteFiles();
            this.fileList = this.initFiles();
        }
        this.resetFile();
    }

    @Override
    public void stop() throws IOException {
        this.closeFile();
        if (this.deleteOnShutdown) {
            this.deleteFiles();
        }
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

