/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.limit;

import io.gridgo.connector.file.support.limit.AbstractFileLimitStrategy;
import io.gridgo.connector.file.support.limit.RandomAccessFileHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class NoLimitStrategy
extends AbstractFileLimitStrategy {
    private String path;
    private String mode;
    private boolean deleteOnStartup;
    private boolean deleteOnShutdown;
    private FileChannel fileChannel;
    private File file;
    private RandomAccessFile raf;
    private boolean override;

    public NoLimitStrategy(String path, String mode, boolean deleteOnStartup, boolean deleteOnShutdown, boolean override) {
        this.path = path;
        this.mode = mode;
        this.deleteOnStartup = deleteOnStartup;
        this.deleteOnShutdown = deleteOnShutdown;
        this.override = override;
    }

    @Override
    public void putBytes(long bytes) throws IOException {
    }

    @Override
    public void readWith(RandomAccessFileHandler consumer) throws IOException {
        if (!this.file.exists()) {
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            consumer.process(raf);
        }
    }

    @Override
    public void start() throws IOException {
        this.file = new File(this.path);
        if (this.deleteOnStartup) {
            this.deleteFile(this.file);
        }
        this.raf = new RandomAccessFile(this.file, this.mode);
        this.fileChannel = this.raf.getChannel();
        if (!this.override) {
            this.raf.seek(this.raf.length());
        }
    }

    @Override
    public void stop() throws IOException {
        this.raf.close();
        if (this.deleteOnShutdown) {
            this.deleteFile(this.file);
        }
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

