/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.file.support.limit;

import io.gridgo.connector.file.support.limit.AbstractFileLimitStrategy;
import io.gridgo.connector.file.support.limit.RandomAccessFileHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatingFileLimitStrategy
extends AbstractFileLimitStrategy {
    private static final Logger log = LoggerFactory.getLogger(RotatingFileLimitStrategy.class);
    private String basePath;
    private String mode;
    private long limit;
    private int count;
    private RandomAccessFile file;
    private FileChannel fileChannel;
    private long written = -1L;
    private File[] files;
    private boolean deleteOnStartup;
    private boolean deleteOnShutdown;
    private boolean override;

    public RotatingFileLimitStrategy(String basePath, String mode, long limit, int count, boolean deleteOnStartup, boolean deleteOnShutdown, boolean override) throws IOException {
        this.basePath = basePath;
        this.mode = mode;
        this.limit = limit;
        this.count = count;
        this.deleteOnStartup = deleteOnStartup;
        this.deleteOnShutdown = deleteOnShutdown;
        this.override = override;
        this.files = this.initFiles();
    }

    private void closeFile() throws IOException {
        this.file.close();
    }

    private void deleteFiles() {
        for (File file : this.files) {
            this.deleteFile(file);
        }
    }

    private File[] initFiles() {
        File[] files = new File[this.count];
        files[0] = new File(this.basePath);
        for (int i = 1; i < this.count; ++i) {
            files[i] = new File(this.basePath + "." + (i - 1));
        }
        return files;
    }

    @Override
    public void putBytes(long bytes) throws IOException {
        this.written += bytes;
        if (this.limit > 0L && this.written > this.limit) {
            this.rotate();
        }
    }

    @Override
    public void readWith(RandomAccessFileHandler consumer) throws IOException {
        for (int i = this.files.length - 1; i >= 0; --i) {
            if (!this.files[i].exists()) continue;
            try (RandomAccessFile raf = new RandomAccessFile(this.files[i], "r");){
                consumer.process(raf);
                continue;
            }
        }
    }

    private void resetFile() throws IOException {
        this.file = new RandomAccessFile(this.basePath, this.mode);
        if (!this.override) {
            long length = this.file.length();
            this.file.seek(length);
            this.written = length;
        } else {
            this.written = 0L;
        }
        this.fileChannel = this.file.getChannel();
    }

    private void rotate() throws IOException {
        this.closeFile();
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                this.deleteFile(f2);
            }
            this.tryRename(f1, f2);
        }
        this.resetFile();
    }

    private void tryRename(File f1, File f2) {
        if (f1.renameTo(f2)) {
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("Cannot rename file from {} to {}", (Object)f1.getAbsolutePath(), (Object)f2.getAbsolutePath());
        }
    }

    @Override
    public void start() throws IOException {
        if (this.deleteOnStartup) {
            this.deleteFiles();
        }
        this.resetFile();
    }

    @Override
    public void stop() throws IOException {
        this.closeFile();
        if (this.deleteOnShutdown) {
            this.deleteFiles();
        }
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

