/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.mongodb;

import com.mongodb.async.client.MongoCollection;
import io.gridgo.connector.DataSourceProvider;
import io.gridgo.connector.impl.AbstractConnector;
import io.gridgo.connector.mongodb.MongoDBProducer;
import io.gridgo.connector.support.annotations.ConnectorEndpoint;
import java.util.Optional;
import org.bson.Document;

@ConnectorEndpoint(scheme="mongodb", syntax="{connectionBean}/{database}[/{collection}]")
public class MongoDBConnector
extends AbstractConnector
implements DataSourceProvider<MongoCollection<Document>> {
    protected void onInit() {
        String connectionBean = this.getPlaceholder("connectionBean").toString();
        String database = this.getPlaceholder("database").toString();
        String collection = this.getPlaceholder("collection");
        String collectionName = collection != null ? collection.toString() : null;
        this.producer = Optional.of(new MongoDBProducer(this.getContext(), connectionBean, database, collectionName));
    }

    public Optional<MongoCollection<Document>> getDataSource() {
        return this.producer.map(p -> ((MongoDBProducer)((Object)p)).getCollection());
    }
}

