/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.connector.mongodb;

import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import io.gridgo.bean.BArray;
import io.gridgo.bean.BElement;
import io.gridgo.bean.BObject;
import io.gridgo.bean.BValue;
import io.gridgo.connector.impl.AbstractProducer;
import io.gridgo.connector.mongodb.support.MongoOperationException;
import io.gridgo.connector.support.config.ConnectorContext;
import io.gridgo.framework.support.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.joo.promise4j.Deferred;
import org.joo.promise4j.Promise;
import org.joo.promise4j.impl.CompletableDeferredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBProducer
extends AbstractProducer {
    private static final Logger log = LoggerFactory.getLogger(MongoDBProducer.class);
    private Map<String, ProducerHandler> operations = new HashMap<String, ProducerHandler>();
    private MongoCollection<Document> collection;
    private String generatedName;

    public MongoDBProducer(ConnectorContext context, String connectionBean, String database, String collectionName) {
        super(context);
        MongoClient connection = (MongoClient)this.getContext().getRegistry().lookupMandatory(connectionBean, MongoClient.class);
        MongoDatabase db = connection.getDatabase(database);
        this.collection = db.getCollection(collectionName);
        this.generatedName = "producer.mongodb." + connectionBean + "." + database + "." + collectionName;
        this.bindHandlers();
    }

    private void bindHandlers() {
        this.bind("Mongo_OperationInsert", this::insertDocument);
        this.bind("Mongo_OperationCount", this::countCollection);
        this.bind("Mongo_OperationFindAll", this::findAllDocuments);
        this.bind("Mongo_OperationFindById", this::findById);
        this.bind("Mongo_OperationUpdateOne", this::updateDocument);
        this.bind("Mongo_OperationUpsert", this::upsertDocument);
        this.bind("Mongo_OperationUpdateMany", this::updateManyDocuments);
        this.bind("Mongo_OperationDeleteOne", this::deleteDocument);
        this.bind("Mongo_OperationDeleteMany", this::deleteManyDocuments);
    }

    public void bind(String name, ProducerHandler handler) {
        this.operations.put(name, handler);
    }

    private Promise<Message, Exception> doCall(Message request, CompletableDeferredObject<Message, Exception> deferred, boolean isRPC) {
        String operation = request.headers().getString("Mongo_Operation");
        ProducerHandler handler = this.operations.get(operation);
        if (handler == null) {
            return Promise.ofCause((Throwable)new IllegalArgumentException("Operation " + operation + " is not supported"));
        }
        try {
            handler.handle(request, (Deferred<Message, Exception>)deferred, isRPC);
        }
        catch (Exception ex) {
            log.error("Error while processing MongoDB request", (Throwable)ex);
            return Promise.ofCause((Throwable)ex);
        }
        return deferred != null ? deferred.promise() : null;
    }

    public Promise<Message, Exception> call(Message request) {
        CompletableDeferredObject deferred = new CompletableDeferredObject();
        return this.doCall(request, (CompletableDeferredObject<Message, Exception>)deferred, true);
    }

    public void countCollection(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        CountOptions options = this.getHeaderAs(msg, "Mongo_CountOptions", CountOptions.class);
        if (options == null) {
            options = new CountOptions();
        }
        this.collection.countDocuments(filter, options, (result, throwable) -> this.ack(deferred, isRPC ? result : null, throwable));
    }

    public void deleteDocument(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        this.collection.deleteOne(filter, (result, throwable) -> this.ack(deferred, result != null && isRPC ? Long.valueOf(result.getDeletedCount()) : null, throwable));
    }

    public void deleteManyDocuments(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        this.collection.deleteMany(filter, (result, throwable) -> this.ack(deferred, result != null && isRPC ? Long.valueOf(result.getDeletedCount()) : null, throwable));
    }

    public void findAllDocuments(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        FindIterable filterable;
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        BObject headers = msg.headers();
        int batchSize = headers.getInteger("Mongo_BatchSize", (Number)-1);
        int numToSkip = headers.getInteger("Mongo_NumToSkip", (Number)-1);
        int limit = headers.getInteger("Mongo_Limit", (Number)-1);
        Bson sortBy = this.getHeaderAs(msg, "Mongo_SortyBy", Bson.class);
        FindIterable findIterable = filterable = filter != null ? this.collection.find(filter) : this.collection.find();
        if (batchSize != -1) {
            filterable.batchSize(batchSize);
        }
        if (numToSkip != -1) {
            filterable.skip(numToSkip);
        }
        if (limit != -1) {
            filterable.limit(limit);
        }
        if (sortBy != null) {
            filterable.sort(sortBy);
        }
        this.applyProjection(msg, (FindIterable<Document>)filterable);
        filterable.into(new ArrayList(), (result, throwable) -> this.ack(deferred, isRPC ? result : null, throwable));
    }

    public void findById(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        BObject headers = msg.headers();
        String idField = headers.getString("Mongo_IdField");
        Object id = msg.body().asValue().getData();
        FindIterable filterable = this.collection.find(Filters.eq((String)idField, (Object)id));
        this.applyProjection(msg, (FindIterable<Document>)filterable);
        filterable.first((result, throwable) -> this.ack(deferred, isRPC ? result : null, throwable));
    }

    private void applyProjection(Message msg, FindIterable<Document> filterable) {
        BObject headers = msg.headers();
        Bson project = this.getHeaderAs(msg, "Mongo_Projection", Bson.class);
        BArray projectInclude = headers.getArray("Mongo_ProjectionInclude", null);
        BArray projectExclude = headers.getArray("Mongo_ProjectionExclude", null);
        if (project != null || projectInclude != null || projectExclude != null) {
            project = this.getProject(project, projectInclude, projectExclude);
            filterable.projection(project);
        }
    }

    private Bson getProject(Bson project, BArray projectInclude, BArray projectExclude) {
        if (projectInclude != null) {
            return Projections.include((String[])this.toStringArray(projectInclude));
        }
        if (projectExclude != null) {
            return Projections.exclude((String[])this.toStringArray(projectExclude));
        }
        return project;
    }

    private String[] toStringArray(BArray array) {
        return (String[])array.stream().filter(element -> element.isValue()).map(element -> element.asValue().getString()).toArray(String[]::new);
    }

    public void insertDocument(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        BElement body = msg.body();
        if (body.isReference()) {
            this.insertSingleDocument(deferred, body);
        } else {
            this.insertManyDocuments(msg, deferred, body);
        }
    }

    private void insertManyDocuments(Message msg, Deferred<Message, Exception> deferred, BElement body) {
        List<Document> docs = this.convertToDocuments(body.asArray());
        InsertManyOptions options = this.getHeaderAs(msg, "Mongo_InsertManyOptions", InsertManyOptions.class);
        if (options == null) {
            options = new InsertManyOptions();
        }
        this.collection.insertMany(docs, options, (ignore, throwable) -> this.ack(deferred, null, throwable));
    }

    private void insertSingleDocument(Deferred<Message, Exception> deferred, BElement body) {
        Document doc = this.convertToDocument(body);
        this.collection.insertOne((Object)doc, (ignore, throwable) -> this.ack(deferred, null, throwable));
    }

    public void updateDocument(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        Document doc = this.convertToDocument(msg.body());
        this.collection.updateOne(filter, (Bson)doc, (result, throwable) -> this.ack(deferred, result != null && isRPC ? Long.valueOf(result.getModifiedCount()) : null, throwable));
    }

    public void upsertDocument(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        Document doc = this.convertToDocument(msg.body());
        this.collection.updateOne(filter, (Bson)doc, new UpdateOptions().upsert(true), (result, throwable) -> this.ack(deferred, result != null && isRPC ? Long.valueOf(result.getModifiedCount()) : null, throwable));
    }

    public void updateManyDocuments(Message msg, Deferred<Message, Exception> deferred, boolean isRPC) {
        Bson filter = this.getHeaderAs(msg, "Mongo_Filter", Bson.class);
        Document doc = this.convertToDocument(msg.body());
        this.collection.updateMany(filter, (Bson)doc, (result, throwable) -> this.ack(deferred, result != null && isRPC ? Long.valueOf(result.getModifiedCount()) : null, throwable));
    }

    private <T> T getHeaderAs(Message msg, String name, Class<T> clazz) {
        BElement options = (BElement)msg.headers().get((Object)name);
        if (options == null || options.isNullValue()) {
            return null;
        }
        return clazz.cast(options.asReference().getReference());
    }

    private void ack(Deferred<Message, Exception> deferred, Object result, Throwable throwable) {
        if (throwable != null) {
            this.ack(deferred, this.convertToException(throwable));
        } else {
            this.ack(deferred, this.convertToMessage(result));
        }
    }

    private Exception convertToException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new MongoOperationException(throwable);
    }

    private Message convertToMessage(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof Long) {
            return this.createMessage(BObject.ofEmpty(), (BElement)BValue.of((Object)result));
        }
        if (result instanceof Document) {
            return this.createMessage(BObject.ofEmpty(), (BElement)this.toBElement((Document)result));
        }
        if (result instanceof List) {
            List cloned = StreamSupport.stream(((List)result).spliterator(), false).map(this::toBElement).collect(Collectors.toList());
            return this.createMessage(BObject.ofEmpty(), (BElement)BArray.of(cloned));
        }
        return null;
    }

    private BObject toBElement(Document doc) {
        return BObject.of((Object)doc);
    }

    private List<Document> convertToDocuments(BArray body) {
        return StreamSupport.stream(body.spliterator(), false).map(this::convertToDocument).collect(Collectors.toList());
    }

    private Document convertToDocument(BElement body) {
        return (Document)body.asReference().getReference();
    }

    public boolean isCallSupported() {
        return true;
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    public void send(Message message) {
        this.doCall(message, null, false);
    }

    public Promise<Message, Exception> sendWithAck(Message message) {
        CompletableDeferredObject deferred = new CompletableDeferredObject();
        return this.doCall(message, (CompletableDeferredObject<Message, Exception>)deferred, false);
    }

    protected String generateName() {
        return this.generatedName;
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    static interface ProducerHandler {
        public void handle(Message var1, Deferred<Message, Exception> var2, boolean var3);
    }
}

