/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.ClientArgs;
import io.grpc.testing.ClientStatus;
import io.grpc.testing.ServerArgs;
import io.grpc.testing.ServerStatus;

public class WorkerGrpc {
    public static final String SERVICE_NAME = "grpc.testing.Worker";
    public static final MethodDescriptor<ClientArgs, ClientStatus> METHOD_RUN_TEST = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.Worker", (String)"RunTest"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ClientArgs.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ClientStatus.getDefaultInstance()));
    public static final MethodDescriptor<ServerArgs, ServerStatus> METHOD_RUN_SERVER = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.Worker", (String)"RunServer"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ServerArgs.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ServerStatus.getDefaultInstance()));
    private static final int METHODID_RUN_TEST = 0;
    private static final int METHODID_RUN_SERVER = 1;

    private WorkerGrpc() {
    }

    public static WorkerStub newStub(Channel channel) {
        return new WorkerStub(channel);
    }

    public static WorkerBlockingStub newBlockingStub(Channel channel) {
        return new WorkerBlockingStub(channel);
    }

    public static WorkerFutureStub newFutureStub(Channel channel) {
        return new WorkerFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(Worker serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_RUN_TEST, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 0))).addMethod(METHOD_RUN_SERVER, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(serviceImpl, 1))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final Worker serviceImpl;
        private final int methodId;

        public MethodHandlers(Worker serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return this.serviceImpl.runTest(responseObserver);
                }
                case 1: {
                    return this.serviceImpl.runServer(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static class WorkerFutureStub
    extends AbstractStub<WorkerFutureStub>
    implements WorkerFutureClient {
        private WorkerFutureStub(Channel channel) {
            super(channel);
        }

        private WorkerFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerFutureStub build(Channel channel, CallOptions callOptions) {
            return new WorkerFutureStub(channel, callOptions);
        }
    }

    public static class WorkerBlockingStub
    extends AbstractStub<WorkerBlockingStub>
    implements WorkerBlockingClient {
        private WorkerBlockingStub(Channel channel) {
            super(channel);
        }

        private WorkerBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerBlockingStub build(Channel channel, CallOptions callOptions) {
            return new WorkerBlockingStub(channel, callOptions);
        }
    }

    public static class WorkerStub
    extends AbstractStub<WorkerStub>
    implements Worker {
        private WorkerStub(Channel channel) {
            super(channel);
        }

        private WorkerStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerStub build(Channel channel, CallOptions callOptions) {
            return new WorkerStub(channel, callOptions);
        }

        @Override
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_RUN_TEST, this.getCallOptions()), responseObserver);
        }

        @Override
        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_RUN_SERVER, this.getCallOptions()), responseObserver);
        }
    }

    public static interface WorkerFutureClient {
    }

    public static interface WorkerBlockingClient {
    }

    public static interface Worker {
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> var1);

        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> var1);
    }
}

