/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractReferenceCounted;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;
    private String authority = "localhost";

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    public InProcessChannelBuilder overrideAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name, this.authority);
    }

    private static class InProcessClientTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final String name;
        private final String authority;

        private InProcessClientTransportFactory(String name, String authority) {
            this.name = name;
            this.authority = authority;
        }

        @Override
        public ClientTransport newClientTransport() {
            return new InProcessTransport(this.name);
        }

        @Override
        public String authority() {
            return this.authority;
        }

        @Override
        protected void deallocate() {
        }
    }
}

