/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.SharedResourceHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ManagedChannelImpl
extends ManagedChannel {
    private static final Logger log = Logger.getLogger(ManagedChannelImpl.class.getName());
    private final ClientTransportFactory transportFactory;
    private final Executor executor;
    private final boolean usingSharedExecutor;
    private final String userAgent;
    private final Object lock = new Object();
    private ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider = new ExponentialBackoffPolicy.Provider();
    private final Channel interceptorChannel;
    @GuardedBy(value="lock")
    private Collection<ClientTransport> transports = new ArrayList<ClientTransport>();
    private volatile ClientTransport activeTransport;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private boolean terminated;
    private long reconnectTimeMillis;
    private BackoffPolicy reconnectPolicy;
    private volatile Compressor defaultCompressor;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get() {
            return ManagedChannelImpl.this.obtainActiveTransport();
        }
    };

    ManagedChannelImpl(ClientTransportFactory transportFactory, @Nullable Executor executor, @Nullable String userAgent, List<ClientInterceptor> interceptors) {
        this.transportFactory = transportFactory;
        this.userAgent = userAgent;
        this.interceptorChannel = ClientInterceptors.intercept((Channel)new RealChannel(), interceptors);
        this.scheduledExecutor = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
        if (executor == null) {
            this.usingSharedExecutor = true;
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        } else {
            this.usingSharedExecutor = false;
            this.executor = executor;
        }
    }

    public void setDefaultCompressor(@Nullable Compressor c) {
        this.defaultCompressor = c != null ? c : Codec.Identity.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedChannelImpl shutdown() {
        ClientTransport savedActiveTransport;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            this.scheduledExecutor = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduledExecutor);
            savedActiveTransport = this.activeTransport;
            if (savedActiveTransport != null) {
                this.activeTransport = null;
            } else if (this.transports.isEmpty()) {
                this.terminated = true;
                this.lock.notifyAll();
                this.onChannelTerminated();
            }
        }
        if (savedActiveTransport != null) {
            savedActiveTransport.shutdown();
        }
        return this;
    }

    @Override
    public ManagedChannelImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        try {
            this.obtainActiveTransport().ping(callback, executor);
        }
        catch (RuntimeException ex) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingFailed(ex);
                }
            });
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        boolean hasCodecOverride;
        boolean bl = hasCodecOverride = callOptions.getCompressor() != null;
        if (!hasCodecOverride && this.defaultCompressor != Codec.Identity.NONE) {
            callOptions = callOptions.withCompressor(this.defaultCompressor);
        }
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientTransport obtainActiveTransport() {
        ClientTransport savedActiveTransport = this.activeTransport;
        if (savedActiveTransport != null && !(savedActiveTransport instanceof InactiveTransport)) {
            return savedActiveTransport;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return null;
            }
            savedActiveTransport = this.activeTransport;
            if (savedActiveTransport instanceof InactiveTransport) {
                if (System.nanoTime() > TimeUnit.MILLISECONDS.toNanos(this.reconnectTimeMillis)) {
                    savedActiveTransport = this.activeTransport = null;
                } else {
                    return savedActiveTransport;
                }
            }
            if (savedActiveTransport != null) {
                return savedActiveTransport;
            }
            ClientTransport newActiveTransport = this.transportFactory.newClientTransport();
            this.transports.add(newActiveTransport);
            boolean failed = true;
            try {
                newActiveTransport.start(new TransportListener(newActiveTransport));
                failed = false;
            }
            finally {
                if (failed) {
                    this.transports.remove(newActiveTransport);
                }
            }
            if (this.transports.contains(newActiveTransport)) {
                this.activeTransport = newActiveTransport;
            }
            return newActiveTransport;
        }
    }

    private void onChannelTerminated() {
        if (this.usingSharedExecutor) {
            SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, (ExecutorService)this.executor);
        }
        this.transportFactory.release();
    }

    private static final class InactiveTransport
    implements ClientTransport {
        private final Status shutdownStatus;

        private InactiveTransport(Status s) {
            this.shutdownStatus = s;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, ClientStreamListener listener) {
            listener.closed(this.shutdownStatus, new Metadata());
            return new ClientCallImpl.NoopClientStream();
        }

        @Override
        public void start(ClientTransport.Listener listener) {
            throw new IllegalStateException();
        }

        @Override
        public void ping(final ClientTransport.PingCallback callback, Executor executor) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.pingFailed(InactiveTransport.this.shutdownStatus.asException());
                }
            });
        }

        @Override
        public void shutdown() {
        }
    }

    private class TransportListener
    implements ClientTransport.Listener {
        private final ClientTransport transport;

        public TransportListener(ClientTransport transport) {
            this.transport = transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.activeTransport == this.transport) {
                    ManagedChannelImpl.this.reconnectPolicy = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.activeTransport == this.transport) {
                    ManagedChannelImpl.this.activeTransport = null;
                    if (s.isOk()) {
                        return;
                    }
                    if (ManagedChannelImpl.this.reconnectPolicy == null) {
                        ManagedChannelImpl.this.reconnectPolicy = ManagedChannelImpl.this.backoffPolicyProvider.get();
                        ManagedChannelImpl.this.reconnectTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    }
                    ManagedChannelImpl.this.activeTransport = new InactiveTransport(s);
                    ManagedChannelImpl.this.reconnectTimeMillis = ManagedChannelImpl.this.reconnectTimeMillis + ManagedChannelImpl.this.reconnectPolicy.nextBackoffMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.activeTransport == this.transport) {
                    log.warning("transportTerminated called without previous transportShutdown");
                    ManagedChannelImpl.this.activeTransport = null;
                }
                this.transportShutdown(Status.UNKNOWN.withDescription("transport shutdown for unknown reason"));
                ManagedChannelImpl.this.transports.remove(this.transport);
                if (ManagedChannelImpl.this.shutdown && ManagedChannelImpl.this.transports.isEmpty()) {
                    if (ManagedChannelImpl.this.terminated) {
                        log.warning("transportTerminated called after already terminated");
                    }
                    ManagedChannelImpl.this.terminated = true;
                    ManagedChannelImpl.this.lock.notifyAll();
                    ManagedChannelImpl.this.onChannelTerminated();
                }
            }
        }
    }

    private class RealChannel
    extends Channel {
        private RealChannel() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(method, new SerializingExecutor(ManagedChannelImpl.this.executor), callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.scheduledExecutor).setUserAgent(ManagedChannelImpl.this.userAgent);
        }

        @Override
        public String authority() {
            return ManagedChannelImpl.this.transportFactory.authority();
        }
    }
}

