/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.squareup.okhttp.internal.spdy.Header;
import io.grpc.Metadata;
import io.grpc.internal.TransportFrameUtil;
import java.util.List;

class Utils {
    static final int DEFAULT_WINDOW_SIZE = 65535;
    static final int CONNECTION_STREAM_ID = 0;

    public static Metadata convertHeaders(List<Header> http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Metadata convertTrailers(List<Header> http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(List<Header> http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Header header : http2Headers) {
            headerValues[i++] = header.name.toByteArray();
            headerValues[i++] = header.value.toByteArray();
        }
        return TransportFrameUtil.toRawSerializedHeaders((byte[][])headerValues);
    }

    private Utils() {
    }
}

