/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.base.Strings;
import io.grpc.benchmarks.qps.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractConfigurationBuilder<T extends Configuration>
implements Configuration.Builder<T> {
    private static final Param HELP = new Param(){

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String getType() {
            return "";
        }

        @Override
        public String getDescription() {
            return "Print this text.";
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Override
        public void setValue(Configuration config, String value) {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public final T build(String[] args) {
        T config = this.newConfiguration();
        Map<String, Param> paramMap = this.getParamMap();
        TreeSet<String> appliedParams = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                throw new IllegalArgumentException("All arguments must start with '--': " + arg);
            }
            String[] pair = arg.substring(2).split("=", 2);
            String key = pair[0];
            String value = "";
            if (pair.length == 2) {
                value = pair[1];
            }
            if (HELP.getName().equalsIgnoreCase(key)) {
                throw new IllegalArgumentException("Help requested");
            }
            Param param = paramMap.get(key);
            if (param == null) {
                throw new IllegalArgumentException("Unsupported argument: " + key);
            }
            param.setValue((Configuration)config, value);
            appliedParams.add(key);
        }
        for (Param param : this.getParams()) {
            if (!param.isRequired() || appliedParams.contains(param.getName())) continue;
            throw new IllegalArgumentException("Missing required option '--" + param.getName() + "'.");
        }
        return this.build0(config);
    }

    @Override
    public final void printUsage() {
        System.out.println("Usage: [ARGS...]");
        int column1Width = 0;
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(HELP);
        params.addAll(this.getParams());
        for (Param param : params) {
            column1Width = Math.max(AbstractConfigurationBuilder.commandLineFlag(param).length(), column1Width);
        }
        int column1Start = 2;
        int column2Start = column1Start + column1Width + 2;
        for (Param param : params) {
            StringBuilder sb = new StringBuilder();
            sb.append(Strings.repeat((String)" ", (int)column1Start));
            sb.append(AbstractConfigurationBuilder.commandLineFlag(param));
            sb.append(Strings.repeat((String)" ", (int)(column2Start - sb.length())));
            String message = param.getDescription();
            sb.append(AbstractConfigurationBuilder.wordWrap(message, column2Start, 80));
            if (param.isRequired()) {
                sb.append(Strings.repeat((String)" ", (int)column2Start));
                sb.append("[Required]\n");
            } else if (param.getDefaultValue() != null && !param.getDefaultValue().isEmpty()) {
                sb.append(Strings.repeat((String)" ", (int)column2Start));
                sb.append("[Default=" + param.getDefaultValue() + "]\n");
            }
            System.out.println(sb);
        }
        System.out.println();
    }

    protected abstract T newConfiguration();

    protected abstract Collection<Param> getParams();

    protected abstract T build0(T var1);

    private Map<String, Param> getParamMap() {
        TreeMap<String, Param> map = new TreeMap<String, Param>(String.CASE_INSENSITIVE_ORDER);
        for (Param param : this.getParams()) {
            map.put(param.getName(), param);
        }
        return map;
    }

    private static String commandLineFlag(Param param) {
        String name = param.getName().toLowerCase(Locale.ROOT);
        String type = !param.getType().isEmpty() ? '=' + param.getType() : "";
        return "--" + name + type;
    }

    private static String wordWrap(String text, int startPos, int maxPos) {
        StringBuilder builder = new StringBuilder();
        int pos = startPos;
        String[] parts = text.split("\\n", -1);
        boolean isBulleted = parts.length > 1;
        for (String part : parts) {
            int lineStart = startPos;
            while (!part.isEmpty()) {
                if (pos < lineStart) {
                    builder.append(Strings.repeat((String)" ", (int)(lineStart - pos)));
                    pos = lineStart;
                }
                int maxLength = maxPos - pos;
                int length = part.length();
                if (length > maxLength && (length = part.lastIndexOf(32, maxPos - pos) + 1) == 0) {
                    length = part.length();
                }
                builder.append(part.substring(0, length));
                part = part.substring(length);
                builder.append("\n");
                pos = 0;
                lineStart = isBulleted ? startPos + 2 : startPos;
            }
        }
        return builder.toString();
    }

    protected static interface Param {
        public String getName();

        public String getType();

        public String getDescription();

        public String getDefaultValue();

        public boolean isRequired();

        public void setValue(Configuration var1, String var2);
    }
}

