/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.common.base.Preconditions;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.InternalManagedChannelProvider;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ManagedChannelProvider;
import io.grpc.ManagedChannelRegistry;
import io.grpc.gcp.observability.interceptors.InternalLoggingChannelInterceptor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;

final class LoggingChannelProvider
extends ManagedChannelProvider {
    private final ManagedChannelProvider prevProvider = ManagedChannelProvider.provider();
    private final InternalLoggingChannelInterceptor.Factory clientInterceptorFactory;
    private static LoggingChannelProvider instance;

    private LoggingChannelProvider(InternalLoggingChannelInterceptor.Factory factory) {
        this.clientInterceptorFactory = factory;
    }

    static synchronized void init(InternalLoggingChannelInterceptor.Factory factory) {
        if (instance != null) {
            throw new IllegalStateException("LoggingChannelProvider already initialized!");
        }
        instance = new LoggingChannelProvider(factory);
        ManagedChannelRegistry.getDefaultRegistry().register((ManagedChannelProvider)instance);
    }

    static synchronized void shutdown() {
        if (instance == null) {
            throw new IllegalStateException("LoggingChannelProvider not initialized!");
        }
        ManagedChannelRegistry.getDefaultRegistry().deregister((ManagedChannelProvider)instance);
        instance = null;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 6;
    }

    private ManagedChannelBuilder<?> addInterceptor(ManagedChannelBuilder<?> builder) {
        return builder.intercept(new ClientInterceptor[]{this.clientInterceptorFactory.create()});
    }

    protected ManagedChannelBuilder<?> builderForAddress(String name, int port) {
        return this.addInterceptor(InternalManagedChannelProvider.builderForAddress((ManagedChannelProvider)this.prevProvider, (String)name, (int)port));
    }

    protected ManagedChannelBuilder<?> builderForTarget(String target) {
        return this.addInterceptor(InternalManagedChannelProvider.builderForTarget((ManagedChannelProvider)this.prevProvider, (String)target));
    }

    protected ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        ManagedChannelProvider.NewChannelBuilderResult result = InternalManagedChannelProvider.newChannelBuilder((ManagedChannelProvider)this.prevProvider, (String)target, (ChannelCredentials)creds);
        ManagedChannelBuilder builder = result.getChannelBuilder();
        if (builder != null) {
            return ManagedChannelProvider.NewChannelBuilderResult.channelBuilder(this.addInterceptor(builder));
        }
        Preconditions.checkNotNull((Object)result.getError(), (Object)"Expected error to be set!");
        return result;
    }

    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

