/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.common.base.Preconditions;
import io.grpc.InternalServerProvider;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerProvider;
import io.grpc.ServerRegistry;
import io.grpc.gcp.observability.interceptors.InternalLoggingServerInterceptor;

final class LoggingServerProvider
extends ServerProvider {
    private final ServerProvider prevProvider = ServerProvider.provider();
    private final InternalLoggingServerInterceptor.Factory serverInterceptorFactory;
    private static LoggingServerProvider instance;

    private LoggingServerProvider(InternalLoggingServerInterceptor.Factory factory) {
        this.serverInterceptorFactory = factory;
    }

    static synchronized void init(InternalLoggingServerInterceptor.Factory factory) {
        if (instance != null) {
            throw new IllegalStateException("LoggingServerProvider already initialized!");
        }
        instance = new LoggingServerProvider(factory);
        ServerRegistry.getDefaultRegistry().register((ServerProvider)instance);
    }

    static synchronized void shutdown() {
        if (instance == null) {
            throw new IllegalStateException("LoggingServerProvider not initialized!");
        }
        ServerRegistry.getDefaultRegistry().deregister((ServerProvider)instance);
        instance = null;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 6;
    }

    private ServerBuilder<?> addInterceptor(ServerBuilder<?> builder) {
        return builder.intercept(this.serverInterceptorFactory.create());
    }

    protected ServerBuilder<?> builderForPort(int port) {
        return this.addInterceptor(InternalServerProvider.builderForPort((ServerProvider)this.prevProvider, (int)port));
    }

    protected ServerProvider.NewServerBuilderResult newServerBuilderForPort(int port, ServerCredentials creds) {
        ServerProvider.NewServerBuilderResult result = InternalServerProvider.newServerBuilderForPort((ServerProvider)this.prevProvider, (int)port, (ServerCredentials)creds);
        ServerBuilder builder = result.getServerBuilder();
        if (builder != null) {
            return ServerProvider.NewServerBuilderResult.serverBuilder(this.addInterceptor(builder));
        }
        Preconditions.checkNotNull((Object)result.getError(), (Object)"Expected error to be set!");
        return result;
    }
}

