/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import io.grpc.Internal;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.util.List;

@Internal
public interface ObservabilityConfig {
    public boolean isEnableCloudLogging();

    public boolean isEnableCloudMonitoring();

    public boolean isEnableCloudTracing();

    public String getDestinationProjectId();

    public Long getFlushMessageCount();

    public List<LogFilter> getLogFilters();

    public List<GrpcLogRecord.EventType> getEventTypes();

    public Sampler getSampler();

    public static class Sampler {
        private SamplerType type;
        private double probability;

        Sampler(double probability) {
            this.probability = probability;
            this.type = SamplerType.PROBABILISTIC;
        }

        Sampler(SamplerType type) {
            this.type = type;
        }

        double getProbability() {
            return this.probability;
        }

        SamplerType getType() {
            return this.type;
        }
    }

    public static enum SamplerType {
        ALWAYS,
        NEVER,
        PROBABILISTIC;

    }

    public static class LogFilter {
        public final String pattern;
        public final Integer headerBytes;
        public final Integer messageBytes;

        public LogFilter(String pattern, Integer headerBytes, Integer messageBytes) {
            this.pattern = pattern;
            this.headerBytes = headerBytes;
            this.messageBytes = messageBytes;
        }
    }
}

