/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Internal;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.internal.JsonParser;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public class GcpLogSink
implements Sink {
    private final Logger logger = Logger.getLogger(GcpLogSink.class.getName());
    private static final String SERVICE_TO_EXCLUDE = "google.logging.v2.LoggingServiceV2";
    private static final String DEFAULT_LOG_NAME = "grpc";
    private static final String K8S_MONITORED_RESOURCE_TYPE = "k8s_container";
    private static final Set<String> kubernetesResourceLabelSet = ImmutableSet.of((Object)"project_id", (Object)"location", (Object)"cluster_name", (Object)"namespace_name", (Object)"pod_name", (Object)"container_name", (Object[])new String[0]);
    private static final long FALLBACK_FLUSH_LIMIT = 100L;
    private final Map<String, String> customTags;
    private final Logging gcpLoggingClient;
    private final MonitoredResource kubernetesResource;
    private final Long flushLimit;
    private long flushCounter;

    private static Logging createLoggingClient(String projectId) {
        LoggingOptions.Builder builder = LoggingOptions.newBuilder();
        if (!Strings.isNullOrEmpty((String)projectId)) {
            builder.setProjectId(projectId);
        }
        return (Logging)builder.build().getService();
    }

    public GcpLogSink(String destinationProjectId, Map<String, String> locationTags, Map<String, String> customTags, Long flushLimit) {
        this(GcpLogSink.createLoggingClient(destinationProjectId), destinationProjectId, locationTags, customTags, flushLimit);
    }

    @VisibleForTesting
    GcpLogSink(Logging client, String destinationProjectId, Map<String, String> locationTags, Map<String, String> customTags, Long flushLimit) {
        this.gcpLoggingClient = client;
        this.customTags = GcpLogSink.getCustomTags(customTags, locationTags, destinationProjectId);
        this.kubernetesResource = GcpLogSink.getResource(locationTags);
        this.flushLimit = flushLimit != null ? flushLimit : 100L;
        this.flushCounter = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(GrpcLogRecord logProto) {
        if (this.gcpLoggingClient == null) {
            this.logger.log(Level.SEVERE, "Attempt to write after GcpLogSink is closed.");
            return;
        }
        if (SERVICE_TO_EXCLUDE.equals(logProto.getServiceName())) {
            return;
        }
        try {
            GrpcLogRecord.EventType event = logProto.getEventType();
            Severity logEntrySeverity = this.getCloudLoggingLevel(logProto.getLogLevel());
            LogEntry.Builder grpcLogEntryBuilder = LogEntry.newBuilder((Payload)Payload.JsonPayload.of(this.protoToMapConverter(logProto))).setSeverity(logEntrySeverity).setLogName(DEFAULT_LOG_NAME).setResource(this.kubernetesResource);
            if (!this.customTags.isEmpty()) {
                grpcLogEntryBuilder.setLabels(this.customTags);
            }
            LogEntry grpcLogEntry = grpcLogEntryBuilder.build();
            GcpLogSink gcpLogSink = this;
            synchronized (gcpLogSink) {
                this.logger.log(Level.FINEST, "Writing gRPC event : {0} to Cloud Logging", (Object)event);
                this.gcpLoggingClient.write(Collections.singleton(grpcLogEntry), new Logging.WriteOption[0]);
                this.flushCounter = ++this.flushCounter;
                if (this.flushCounter >= this.flushLimit) {
                    this.gcpLoggingClient.flush();
                    this.flushCounter = 0L;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while writing to Cloud Logging", e);
        }
    }

    @VisibleForTesting
    static Map<String, String> getCustomTags(Map<String, String> customTags, Map<String, String> locationTags, String destinationProjectId) {
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
        String sourceProjectId = locationTags.get("project_id");
        if (!Strings.isNullOrEmpty((String)destinationProjectId) && !Objects.equals(sourceProjectId, destinationProjectId)) {
            tagsBuilder.put((Object)"source_project_id", (Object)sourceProjectId);
        }
        if (customTags != null) {
            tagsBuilder.putAll(customTags);
        }
        return tagsBuilder.buildOrThrow();
    }

    @VisibleForTesting
    static MonitoredResource getResource(Map<String, String> resourceTags) {
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)K8S_MONITORED_RESOURCE_TYPE);
        if (resourceTags != null && !resourceTags.isEmpty()) {
            for (Map.Entry<String, String> entry : resourceTags.entrySet()) {
                String resourceKey = entry.getKey();
                if (!kubernetesResourceLabelSet.contains(resourceKey)) continue;
                builder.addLabel(resourceKey, entry.getValue());
            }
        }
        return builder.build();
    }

    private Map<String, Object> protoToMapConverter(GrpcLogRecord logProto) throws IOException {
        JsonFormat.Printer printer = JsonFormat.printer().preservingProtoFieldNames();
        String recordJson = printer.print((MessageOrBuilder)logProto);
        return (Map)JsonParser.parse((String)recordJson);
    }

    private Severity getCloudLoggingLevel(GrpcLogRecord.LogLevel recordLevel) {
        switch (recordLevel.getNumber()) {
            case 1: 
            case 2: {
                return Severity.DEBUG;
            }
            case 3: {
                return Severity.INFO;
            }
            case 4: {
                return Severity.WARNING;
            }
            case 5: {
                return Severity.ERROR;
            }
            case 6: {
                return Severity.CRITICAL;
            }
        }
        return Severity.DEFAULT;
    }

    @Override
    public synchronized void close() {
        if (this.gcpLoggingClient == null) {
            this.logger.log(Level.WARNING, "Attempt to close after GcpLogSink is closed.");
            return;
        }
        try {
            this.gcpLoggingClient.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while closing", e);
        }
    }
}

